/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.client;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.UpstreamValidator;
import com.atlassian.bitbucket.server.ApplicationState;
import com.atlassian.bitbucket.util.DevModeUtils;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultUpstreamValidator
implements UpstreamValidator {
    private static final Logger log = LoggerFactory.getLogger(DefaultUpstreamValidator.class);
    private final HttpClient httpClient;
    private final I18nService i18nService;

    public DefaultUpstreamValidator(HttpClient httpClient, I18nService i18nService) {
        this.httpClient = httpClient;
        this.i18nService = i18nService;
    }

    @Override
    @Nonnull
    public Optional<KeyedMessage> validate(@Nonnull String url) {
        try {
            URL parsedUrl = new URL(url);
            if (!DevModeUtils.isEnabled() && !DefaultUpstreamValidator.isHttpsUrl(parsedUrl)) {
                return Optional.of(this.message("bitbucket.mirroring.upstream.validation.url.not.https"));
            }
            String statusUrl = StringUtils.stripEnd((String)url, (String)"/") + "/status";
            ResponsePromise responsePromise = this.httpClient.newRequest(statusUrl).get();
            Response response = (Response)responsePromise.get(10L, TimeUnit.SECONDS);
            Optional<ApplicationState> state = this.parseUpstreamState(response);
            if (state.isPresent()) {
                if (state.get() == ApplicationState.RUNNING) {
                    if (response.isOk()) {
                        return Optional.empty();
                    }
                    return this.badResponse();
                }
                return state.flatMap(this::messageFromState);
            }
            return this.badResponse();
        }
        catch (MalformedURLException e) {
            return Optional.of(this.message("bitbucket.mirroring.upstream.validation.url.invalid"));
        }
        catch (ExecutionException e) {
            log.warn("HTTP request to primary failed.", (Throwable)e);
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof UnknownHostException) {
                return Optional.of(this.message("bitbucket.mirroring.upstream.validation.unknown.host", rootCause.getMessage()));
            }
            if (rootCause instanceof SocketException) {
                return Optional.of(this.message("bitbucket.mirroring.upstream.validation.bad.connection", rootCause.getMessage()));
            }
            if (rootCause instanceof SSLException) {
                return Optional.of(this.message("bitbucket.mirroring.upstream.validation.bad.connection.ssl", rootCause.getMessage()));
            }
            return Optional.of(this.message("bitbucket.mirroring.upstream.validation.general"));
        }
        catch (InterruptedException | TimeoutException e) {
            log.warn("HTTP request to primary failed with timeout.", (Throwable)e);
            return Optional.of(this.message("bitbucket.mirroring.upstream.validation.timeout"));
        }
    }

    private static boolean isHttpsUrl(URL url) {
        return url != null && "https".equalsIgnoreCase(url.getProtocol());
    }

    private Optional<KeyedMessage> badResponse() {
        return Optional.of(this.message("bitbucket.mirroring.upstream.validation.bad.response"));
    }

    private KeyedMessage message(String key) {
        return this.i18nService.createKeyedMessage(key, new Object[0]);
    }

    private KeyedMessage message(String key, Object ... args) {
        return this.i18nService.createKeyedMessage(key, args);
    }

    private Optional<KeyedMessage> messageFromState(ApplicationState state) {
        switch (state) {
            case ERROR: {
                return Optional.of(this.message("bitbucket.mirroring.upstream.validation.state.error"));
            }
            case MAINTENANCE: {
                return Optional.of(this.message("bitbucket.mirroring.upstream.validation.state.maintenance"));
            }
            case STARTING: {
                return Optional.of(this.message("bitbucket.mirroring.upstream.validation.state.starting"));
            }
            case STOPPING: {
                return Optional.of(this.message("bitbucket.mirroring.upstream.validation.state.stopping"));
            }
            case FIRST_RUN: {
                return Optional.of(this.message("bitbucket.mirroring.upstream.validation.state.setup"));
            }
            case RUNNING: {
                return Optional.empty();
            }
        }
        log.warn("Primary server reported an unknown state: {}", (Object)state);
        return this.badResponse();
    }

    private Optional<ApplicationState> parseUpstreamState(InputStream stream) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            ServerUpstreamStatusResponse status = (ServerUpstreamStatusResponse)mapper.readValue(stream, ServerUpstreamStatusResponse.class);
            return Optional.ofNullable(status.state);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ApplicationState> parseUpstreamState(Response response) {
        if (!response.hasEntity()) {
            return Optional.empty();
        }
        InputStream stream = response.getEntityStream();
        try {
            Optional<ApplicationState> optional = this.parseUpstreamState(stream);
            return optional;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ServerUpstreamStatusResponse {
        private final ApplicationState state;

        @JsonCreator
        public ServerUpstreamStatusResponse(@JsonProperty(value="state") ApplicationState state) {
            this.state = state;
        }
    }
}

