/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.client;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="mirroringHttpClientFactory")
public class MirroringHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(MirroringHttpClientFactory.class);
    private final HttpClientFactory factory;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public MirroringHttpClientFactory(HttpClientFactory factory, ApplicationPropertiesService propertiesService) {
        this.factory = factory;
        this.propertiesService = propertiesService;
    }

    @Nonnull
    public CloseableHttpClient create() {
        HttpClientOptions options = new HttpClientOptions();
        options.setSocketTimeout(this.propertiesService.getPluginProperty("plugin.mirroring.upstream.request.socket.timeout", 15), TimeUnit.SECONDS);
        options.setRequestTimeout(this.propertiesService.getPluginProperty("plugin.mirroring.upstream.request.timeout", 15), TimeUnit.SECONDS);
        options.setUserAgent("Mirror");
        options.setSupportedProtocols(new String[]{"TLSv1.2"});
        options.setIgnoreCookies(true);
        final HttpClient delegate = this.factory.create(options);
        return new CloseableHttpClient(){

            @Override
            public void close() {
                try {
                    MirroringHttpClientFactory.this.factory.dispose(delegate);
                }
                catch (Exception e) {
                    log.debug("Failed to dispose a HttpClient");
                    log.trace("Dispose error:", (Throwable)e);
                }
            }

            public Request.Builder newRequest() {
                return delegate.newRequest();
            }

            public Request.Builder newRequest(URI uri) {
                return delegate.newRequest(uri);
            }

            public Request.Builder newRequest(String uri) {
                return delegate.newRequest(uri);
            }

            public Request.Builder newRequest(URI uri, String contentType, String entity) {
                return delegate.newRequest(uri, contentType, entity);
            }

            public Request.Builder newRequest(String uri, String contentType, String entity) {
                return delegate.newRequest(uri, contentType, entity);
            }

            public void flushCacheByUriPattern(Pattern uriPattern) {
                delegate.flushCacheByUriPattern(uriPattern);
            }

            public <A> ResponseTransformation.Builder<A> transformation() {
                return delegate.transformation();
            }

            public ResponsePromise execute(Request request) {
                return delegate.execute(request);
            }
        };
    }

    public static interface CloseableHttpClient
    extends HttpClient,
    Closeable {
    }
}

