/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.client;

import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashService;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.UpstreamRepositoryHashesCallback;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRepositoryHashParser {
    private static final Logger log = LoggerFactory.getLogger(ServerRepositoryHashParser.class);
    private final JsonParser jsonParser;

    public ServerRepositoryHashParser(@Nonnull JsonParser jsonParser) {
        this.jsonParser = Objects.requireNonNull(jsonParser, "jsonParser");
    }

    public int stream(@Nonnull UpstreamRepositoryHashesCallback callback) throws IOException {
        JsonToken token = this.jsonParser.nextToken();
        if (token == null) {
            return 0;
        }
        this.requireToken(token, JsonToken.START_OBJECT);
        callback.onStart();
        Instant lastUpdate = Instant.now();
        int read = 0;
        while ((token = this.jsonParser.nextToken()) != JsonToken.END_OBJECT) {
            this.requireToken(token, JsonToken.FIELD_NAME);
            String field = this.jsonParser.getCurrentName();
            if ("projects".equals(field)) {
                read += this.streamProjects(callback);
                continue;
            }
            if ("lastUpdate".equals(field)) {
                if (this.jsonParser.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                    lastUpdate = Instant.ofEpochMilli(this.jsonParser.getLongValue());
                    continue;
                }
                log.trace("Unexpected value found for lastUpdate, falling back to a sane value");
                continue;
            }
            log.trace("Ignoring unexpected field: {}", (Object)field);
            this.skipNextToken();
        }
        callback.onEnd(lastUpdate);
        return read;
    }

    private void requireNextBoolean() throws IOException {
        JsonToken token = this.jsonParser.nextToken();
        if (token != JsonToken.VALUE_TRUE && token != JsonToken.VALUE_FALSE) {
            throw new IllegalStateException("Invalid JSON payload: Found " + String.valueOf(token) + " (" + this.jsonParser.getCurrentName() + ") where either " + String.valueOf(JsonToken.VALUE_TRUE) + " or " + String.valueOf(JsonToken.VALUE_FALSE) + " was expected");
        }
    }

    private void requireNextField(String fieldName, String position) throws IOException {
        this.requireNextToken(JsonToken.FIELD_NAME);
        if (!fieldName.equals(this.jsonParser.getCurrentName())) {
            throw new IllegalStateException("Invalid JSON payload: \"" + fieldName + "\" is required to be the " + position + " field for a project object, but found \"" + this.jsonParser.getCurrentName() + "\"");
        }
    }

    private void requireNextToken(JsonToken required) throws IOException {
        this.requireToken(this.jsonParser.nextToken(), required);
    }

    private void requireToken(JsonToken token, JsonToken required) throws IOException {
        if (token != required) {
            throw new IllegalStateException("Invalid JSON payload: Found " + String.valueOf(token) + " (" + this.jsonParser.getCurrentName() + ") where " + String.valueOf(required) + " was expected");
        }
    }

    private void skipNextToken() throws IOException {
        this.skipToken(this.jsonParser.nextToken());
    }

    private void skipToken(JsonToken token) throws IOException {
        if (token == JsonToken.START_ARRAY || token == JsonToken.START_OBJECT) {
            this.jsonParser.skipChildren();
        }
    }

    private int streamProjects(UpstreamRepositoryHashesCallback callback) throws IOException {
        this.requireNextToken(JsonToken.START_ARRAY);
        int read = 0;
        JsonToken token;
        block0: while ((token = this.jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            this.requireToken(token, JsonToken.START_OBJECT);
            this.requireNextField("id", "first");
            this.requireNextToken(JsonToken.VALUE_NUMBER_INT);
            String projectId = this.jsonParser.getText();
            this.requireNextField("public", "second");
            this.requireNextBoolean();
            boolean publiclyAccessible = this.jsonParser.getBooleanValue();
            boolean include = callback.onProject(projectId, publiclyAccessible);
            while (true) {
                if ((token = this.jsonParser.nextToken()) == JsonToken.END_OBJECT) continue block0;
                this.requireToken(token, JsonToken.FIELD_NAME);
                String field = this.jsonParser.getCurrentName();
                if ("repositories".equals(field)) {
                    if (include) {
                        read += this.streamRepositories(callback);
                        continue;
                    }
                    this.skipNextToken();
                    continue;
                }
                log.trace("Ignoring unknown project field: {}", (Object)field);
                this.skipNextToken();
            }
            break;
        }
        return read;
    }

    private int streamRepositories(UpstreamRepositoryHashesCallback callback) throws IOException {
        this.requireNextToken(JsonToken.START_ARRAY);
        int read = 0;
        JsonToken token;
        while ((token = this.jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            this.requireToken(token, JsonToken.START_OBJECT);
            JsonNode repository = (JsonNode)this.jsonParser.readValueAsTree();
            JsonNode id = repository.path("id");
            if (id.isMissingNode() || id.isNull()) {
                log.debug("Ignoring repository with no ID");
                continue;
            }
            JsonNode hashes = repository.path("hashes");
            String contentHash = (String)ObjectUtils.firstNonNull((Object[])new String[]{hashes.path("content").textValue(), DmzMirrorHashService.NULL_HASH});
            String metadataHash = (String)ObjectUtils.firstNonNull((Object[])new String[]{hashes.path("metadata").textValue(), DmzMirrorHashService.NULL_HASH});
            long contentUpdatedDate = hashes.path("contentUpdatedDate").asLong();
            long metadataUpdatedDate = hashes.path("metadataUpdatedDate").asLong();
            callback.onRepository(id.asText(), contentHash, contentUpdatedDate > 0L ? new Date(contentUpdatedDate) : null, metadataHash, metadataUpdatedDate > 0L ? new Date(metadataUpdatedDate) : null);
            ++read;
        }
        return read;
    }
}

