/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.command;

import com.atlassian.bitbucket.dmz.process.BufferStdinHandler;
import com.atlassian.bitbucket.dmz.process.LoggingStdoutHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.SyncCredentials;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.SyncCredentialsManager;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.repository.RefCallback;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AsyncCommand;
import com.atlassian.bitbucket.scm.AuthenticationFailedScmException;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.RefsCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitExtendedCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncCallback;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncCommandParameters;
import com.atlassian.bitbucket.scm.ref.LsRemoteCommandParameters;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Future;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirroringCommandFactory {
    @VisibleForTesting
    static final String AUTHENTICATION_ERROR_KEY = "bitbucket.git.mirror.remote.authenticationerror";
    private final GitCommandBuilderFactory commandBuilderFactory;
    private final GitCommandFactory commandFactory;
    private final SyncCredentialsManager credentialsManager;
    private final GitExtendedCommandFactory extendedCommandFactory;
    private final I18nService i18nService;
    private final MirroringConfig mirroringConfig;
    private final ScmService scmService;

    @Autowired
    public MirroringCommandFactory(GitCommandFactory commandFactory, GitCommandBuilderFactory commandBuilderFactory, GitExtendedCommandFactory extendedCommandFactory, SyncCredentialsManager credentialsManager, I18nService i18nService, MirroringConfig mirroringConfig, ScmService scmService) {
        this.commandBuilderFactory = commandBuilderFactory;
        this.commandFactory = commandFactory;
        this.credentialsManager = credentialsManager;
        this.extendedCommandFactory = extendedCommandFactory;
        this.mirroringConfig = mirroringConfig;
        this.i18nService = i18nService;
        this.scmService = scmService;
    }

    @Nonnull
    public Command<Void> lsRemote(@Nonnull MirrorRepository mirrorRepository, @Nonnull RefCallback callback) {
        Objects.requireNonNull(mirrorRepository, "mirrorRepository");
        Objects.requireNonNull(callback, "callback");
        String cloneUrl = mirrorRepository.getUpstreamCloneUrl();
        SyncCredentials credentials = (SyncCredentials)this.credentialsManager.getCredentials(mirrorRepository.getUpstreamId()).claim();
        File privateKey = credentials.getKeyFile().toFile();
        LsRemoteCommandParameters parameters = new LsRemoteCommandParameters.Builder(cloneUrl, privateKey, mirrorRepository.getRepository(), this.mirroringConfig.getRemoteCommandIdleTimeout(), this.mirroringConfig.getSyncLsRemoteTimeout()).withEnvironment("BB_IS_MIRROR", "1").build();
        GitCommand command = this.extendedCommandFactory.lsRemote(mirrorRepository.getRepository(), parameters, callback);
        return new CredentialRefreshingCommandDecorator(credentials, this.credentialsManager, (Command<Void>)command);
    }

    @Nonnull
    public GitCommand<Void> refs(@Nonnull MirrorRepository mirrorRepository, @Nonnull RefCallback callback) {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(mirrorRepository, "mirrorRepository");
        RefsCommandParameters params = new RefsCommandParameters.Builder().build();
        GitCommand command = this.extendedCommandFactory.rawRefs(mirrorRepository.getRepository(), params, callback);
        command.setExecutionTimeout(this.mirroringConfig.getSyncLsRemoteTimeout());
        command.setIdleTimeout(this.mirroringConfig.getRemoteCommandIdleTimeout());
        return command;
    }

    @Nonnull
    public Command<Void> synchronize(@Nonnull MirrorRepository mirrorRepository, @Nonnull MirrorSyncCommandParameters parameters) {
        Objects.requireNonNull(mirrorRepository, "mirrorRepository");
        Objects.requireNonNull(parameters, "parameters");
        SyncCredentials credentials = (SyncCredentials)this.credentialsManager.getCredentials(mirrorRepository.getUpstreamId()).claim();
        MirrorSyncCommandParameters commandParameters = credentials.configure(new MirrorSyncCommandParameters.Builder(parameters)).build();
        Command command = this.scmService.getMirrorCommandFactory(mirrorRepository.getRepository()).synchronize(commandParameters, new MirrorSyncCallback(this){});
        command.setExecutionTimeout(this.mirroringConfig.getSyncExecTimeout());
        command.setIdleTimeout(this.mirroringConfig.getRemoteCommandIdleTimeout());
        return new CredentialRefreshingCommandDecorator(credentials, this.credentialsManager, (Command<Void>)command);
    }

    @Nonnull
    public GitCommand<Void> updateRefs(@Nonnull Repository repository, @Nonnull Iterator<String> instructions) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(instructions, "instructions");
        GitCommand command = ((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)this.commandBuilderFactory.builder(repository).command("update-ref")).argument("--stdin")).argument("-z")).inputHandler((CommandInputHandler)new BufferStdinHandler(String.join((CharSequence)"", () -> instructions)))).build((CommandOutputHandler)new LoggingStdoutHandler());
        command.setIdleTimeout(this.mirroringConfig.getLocalCommandIdleTimeout());
        return command;
    }

    private static class CredentialRefreshingCommandDecorator
    implements Command<Void> {
        private final SyncCredentials credentials;
        private final SyncCredentialsManager credentialsManager;
        private final Command<Void> delegate;

        private CredentialRefreshingCommandDecorator(SyncCredentials credentials, SyncCredentialsManager credentialsManager, Command<Void> delegate) {
            this.delegate = delegate;
            this.credentials = credentials;
            this.credentialsManager = credentialsManager;
        }

        @Nonnull
        public AsyncCommand<Void> asynchronous() {
            return new AsyncCommand<Void>(){

                @Nonnull
                public Future<Void> start() {
                    return delegate.asynchronous().start();
                }

                @Nonnull
                public Command<Void> synchronous() {
                    throw new UnsupportedOperationException("Synchronous commands are not supported");
                }
            };
        }

        @Nullable
        public Void call() {
            try {
                return (Void)this.delegate.call();
            }
            catch (AuthenticationFailedScmException e) {
                this.credentialsManager.refresh(this.credentials);
                throw e;
            }
        }

        public void setExecutionTimeout(long timeoutInSecs) {
            this.delegate.setExecutionTimeout(timeoutInSecs);
        }

        public void setIdleTimeout(long timeoutInSecs) {
            this.delegate.setIdleTimeout(timeoutInSecs);
        }
    }
}

