/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.MappingDaoHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.ProjectMappingDao;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AoProjectMappingDao
extends AbstractAoDao
implements ProjectMappingDao {
    @Autowired
    public AoProjectMappingDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public void clearAllProgress(@Nonnull String upstreamServerId) {
        AoProjectMapping[] mappings;
        Objects.requireNonNull(upstreamServerId, "upstreamServerId");
        for (AoProjectMapping mapping : mappings = (AoProjectMapping[])this.ao.find(AoProjectMapping.class, Query.select().from(AoProjectMapping.class).where("IN_PROGRESS = ? AND UPSTREAM_ID = ?", new Object[]{Boolean.TRUE, upstreamServerId}))) {
            mapping.setInProgress(false);
            mapping.save();
        }
    }

    @Override
    @Nonnull
    public AoProjectMapping create(@Nonnull Integer localId, @Nonnull String upstreamServerId, @Nonnull String upstreamProjectId, @Nonnull String externalProjectKey, @Nonnull String externalProjectName) {
        return (AoProjectMapping)this.ao.create(AoProjectMapping.class, (Map)ImmutableMap.builder().put((Object)"LOCAL_ID", (Object)localId).put((Object)"EXTERNAL_ID", (Object)upstreamProjectId).put((Object)"UPSTREAM_ID", (Object)upstreamServerId).put((Object)"IN_PROGRESS", (Object)true).put((Object)"EXTERNAL_KEY", (Object)externalProjectKey).put((Object)"EXTERNAL_NAME", (Object)externalProjectName).build());
    }

    @Override
    public void delete(@Nonnull Integer localId) {
        this.ao.deleteWithSQL(AoProjectMapping.class, "LOCAL_ID = ?", new Object[]{localId});
    }

    @Override
    public void delete(@Nonnull String upstreamServerId, @Nonnull String upstreamProjectId) {
        this.ao.deleteWithSQL(AoProjectMapping.class, "UPSTREAM_ID = ? AND EXTERNAL_ID = ?", new Object[]{upstreamServerId, upstreamProjectId});
    }

    @Override
    @Nonnull
    public Page<AoProjectMapping> findAll(@Nonnull PageRequest pageRequest) {
        boolean isPSQL;
        boolean bl = isPSQL = this.ao.moduleMetaData().getDatabaseType() == DatabaseType.POSTGRESQL;
        if (isPSQL) {
            return this.pageQuery(AoProjectMapping.class, Query.select(), pageRequest);
        }
        return this.pageQuery(AoProjectMapping.class, Query.select().order(AoUtils.lengthFunction((ActiveObjects)this.ao) + "(" + this.quoteColumnName("EXTERNAL_ID") + "), " + this.quoteColumnName("EXTERNAL_ID")), pageRequest);
    }

    @Override
    public AoProjectMapping getByLocalId(@Nonnull Integer localId) {
        return (AoProjectMapping)this.ao.get(AoProjectMapping.class, (Object)localId);
    }

    @Override
    public AoProjectMapping getByUpstreamId(@Nonnull String upstreamServerId, @Nonnull String upstreamProjectId) {
        Objects.requireNonNull(upstreamServerId, "upstreamServerId");
        Objects.requireNonNull(upstreamProjectId, "upstreamProjectId");
        AoProjectMapping[] mappings = (AoProjectMapping[])this.ao.find(AoProjectMapping.class, Query.select().where("UPSTREAM_ID = ? AND EXTERNAL_ID = ?", new Object[]{upstreamServerId, upstreamProjectId}));
        return mappings != null && mappings.length > 0 ? mappings[0] : null;
    }

    @Override
    @Nonnull
    public Iterable<AoProjectMapping> getByUpstreamId(@Nonnull String upstreamServerId, @Nonnull Iterable<String> upstreamProjectIds) {
        Objects.requireNonNull(upstreamServerId, "upstreamServerId");
        Objects.requireNonNull(upstreamProjectIds, "upstreamProjectIds");
        ArrayList<AoProjectMapping> mappings = new ArrayList<AoProjectMapping>();
        Iterable batches = Iterables.partition(upstreamProjectIds, (int)100);
        for (List batch : batches) {
            StringBuilder whereClause = new StringBuilder();
            ArrayList<String> arguments = new ArrayList<String>();
            whereClause.append("UPSTREAM_ID = ? ");
            arguments.add(upstreamServerId);
            whereClause.append("AND EXTERNAL_ID IN (");
            whereClause.append(MappingDaoHelper.inClausePlaceholder(batch));
            whereClause.append(")");
            arguments.addAll(batch);
            AoProjectMapping[] aoProjectMappings = (AoProjectMapping[])this.ao.find(AoProjectMapping.class, Query.select().where(whereClause.toString(), arguments.toArray()).order("LOCAL_ID ASC"));
            Collections.addAll(mappings, aoProjectMappings);
        }
        return mappings;
    }

    @Override
    @Nullable
    public String getExternalKeyByLocalId(int localId) {
        return this.getExternalKeyByLocalId(localId, null);
    }

    @Override
    @Nullable
    public String getExternalKeyByLocalId(int localId, @Nullable String defaultValue) {
        AoProjectMapping mapping = this.getByLocalId(localId);
        if (mapping == null) {
            return defaultValue;
        }
        return mapping.getExternalKey();
    }

    @Override
    @Nonnull
    public Set<Integer> getLocalIdsByUpstreamId(String upstreamId) {
        HashSet<Integer> localProjectIds = new HashSet<Integer>();
        this.ao.stream(AoProjectMapping.class, Query.select((String)"LOCAL_ID").where("UPSTREAM_ID = ?", new Object[]{upstreamId}), projectMapping -> localProjectIds.add(projectMapping.getLocalId()));
        return localProjectIds;
    }

    @Override
    public void updateExternalMapping(int localId, @Nonnull String externalKey, @Nonnull String externalName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)externalKey), (Object)"externalKey is empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)externalName), (Object)"externalName is empty");
        AoProjectMapping mapping = this.getByLocalId(localId);
        if (mapping != null) {
            mapping.setExternalKey(externalKey);
            mapping.setExternalName(externalName);
            mapping.save();
        }
    }
}

