/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoRepositoryFetchTask;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.RepositoryFetchTaskDao;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AoRepositoryFetchTaskDao
extends AbstractAoDao
implements RepositoryFetchTaskDao {
    @Autowired
    public AoRepositoryFetchTaskDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public AoRepositoryFetchTask create(@Nonnull String cloneUrl, @Nonnull String contentHash, int forkDepth, @Nonnull String hierarchyId, int repositoryId, @Nonnull String upstreamId) {
        AoRepositoryFetchTask task = (AoRepositoryFetchTask)this.ao.create(AoRepositoryFetchTask.class, (Map)ImmutableMap.builder().put((Object)"CLONE_URL", (Object)Objects.requireNonNull(cloneUrl, "cloneUrl")).put((Object)"CONTENT_HASH", (Object)Objects.requireNonNull(contentHash, "contentHash")).put((Object)"CREATED_DATE", (Object)new Date()).put((Object)"FORK_DEPTH", (Object)forkDepth).put((Object)"HIERARCHY_ID", (Object)Objects.requireNonNull(hierarchyId, "hierarchyId")).put((Object)"REPOSITORY_ID", (Object)repositoryId).put((Object)"UPSTREAM_ID", (Object)Objects.requireNonNull(upstreamId, "upstreamId")).build());
        this.ao.deleteWithSQL(AoRepositoryFetchTask.class, "REPOSITORY_ID = ? AND ID < ?", new Object[]{task.getRepositoryId(), task.getId()});
        return task;
    }

    @Override
    public void delete(@Nonnull AoRepositoryFetchTask task) {
        this.ao.delete(new RawEntity[]{task});
    }

    @Override
    @Nonnull
    public List<AoRepositoryFetchTask> findByRepositoryId(int repositoryId) {
        return Arrays.asList((AoRepositoryFetchTask[])this.ao.find(AoRepositoryFetchTask.class, Query.select().where("REPOSITORY_ID = ?", new Object[]{repositoryId}).order("ID")));
    }

    @Override
    public Integer findNextRepositoryToFetch(@Nonnull String hierarchyId) {
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        AoRepositoryFetchTask[] tasks = (AoRepositoryFetchTask[])this.ao.find(AoRepositoryFetchTask.class, Query.select().where("HIERARCHY_ID = ?", new Object[]{hierarchyId}).order("FORK_DEPTH, ID").limit(1));
        return tasks == null || tasks.length == 0 ? null : Integer.valueOf(tasks[0].getRepositoryId());
    }

    @Override
    public AoRepositoryFetchTask getById(long id) {
        return (AoRepositoryFetchTask)this.ao.get(AoRepositoryFetchTask.class, (Object)id);
    }

    @Override
    @Nonnull
    public List<String> getHierarchies() {
        LinkedHashSet result = new LinkedHashSet();
        this.ao.stream(AoRepositoryFetchTask.class, Query.select((String)"ID, HIERARCHY_ID").order("ID"), task -> result.add(task.getHierarchyId()));
        return ImmutableList.copyOf(result);
    }
}

