/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoRepositoryMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.MappingDaoHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.RepositoryMappingDao;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.java.ao.Query;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AoRepositoryMappingDao
extends AbstractAoDao
implements RepositoryMappingDao {
    private static final Logger log = LoggerFactory.getLogger(AoRepositoryMappingDao.class);

    @Autowired
    public AoRepositoryMappingDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public int countSyncedInProgress(@Nonnull String upstreamServerId) {
        return this.ao.count(AoRepositoryMapping.class, Query.select().alias(AoProjectMapping.class, "ProjectMapping").alias(AoRepositoryMapping.class, "RepositoryMapping").join(AoProjectMapping.class, "RepositoryMapping.PROJECT_ID=ProjectMapping.LOCAL_ID").where("(RepositoryMapping.LAST_SYNC IS NOT NULL OR RepositoryMapping.FAILED_SYNC_COUNT > 0) AND ProjectMapping.IN_PROGRESS = ? AND ProjectMapping.UPSTREAM_ID = ?", new Object[]{Boolean.TRUE, upstreamServerId}));
    }

    @Override
    public int countAllInProgress(@Nonnull String upstreamServerId) {
        return this.ao.count(AoRepositoryMapping.class, Query.select().alias(AoProjectMapping.class, "ProjectMapping").alias(AoRepositoryMapping.class, "RepositoryMapping").join(AoProjectMapping.class, "RepositoryMapping.PROJECT_ID=ProjectMapping.LOCAL_ID").where("ProjectMapping.IN_PROGRESS = ? AND ProjectMapping.UPSTREAM_ID = ?", new Object[]{Boolean.TRUE, upstreamServerId}));
    }

    @Override
    @Nonnull
    public AoRepositoryMapping create(int localId, @Nonnull String upstreamServerId, int localProjectId, @Nonnull String upstreamRepositoryId) {
        return (AoRepositoryMapping)this.ao.create(AoRepositoryMapping.class, (Map)ImmutableMap.builder().put((Object)"LOCAL_ID", (Object)localId).put((Object)"UPSTREAM_ID", (Object)upstreamServerId).put((Object)"PROJECT_ID", (Object)localProjectId).put((Object)"EXTERNAL_ID", (Object)upstreamRepositoryId).put((Object)"FAILED_SYNC_COUNT", (Object)0).build());
    }

    @Override
    public void delete(@Nonnull String upstreamServerId, @Nonnull String upstreamRepositoryId) {
        this.ao.deleteWithSQL(AoRepositoryMapping.class, "UPSTREAM_ID = ? AND EXTERNAL_ID = ?", new Object[]{upstreamServerId, upstreamRepositoryId});
    }

    @Override
    @Nonnull
    public Page<AoRepositoryMapping> findByUpstreamId(@Nonnull String upstreamServerId, @Nonnull PageRequest pageRequest) {
        return this.pageQuery(AoRepositoryMapping.class, Query.select().from(AoRepositoryMapping.class).where("UPSTREAM_ID = ?", new Object[]{upstreamServerId}).order("EXTERNAL_ID"), pageRequest);
    }

    @Override
    public AoRepositoryMapping getByLocalId(int id) {
        return (AoRepositoryMapping)this.ao.get(AoRepositoryMapping.class, (Object)id);
    }

    @Override
    @Nullable
    public AoRepositoryMapping getByUpstreamId(@Nonnull String upstreamServerId, @Nonnull String upstreamRepositoryId) {
        Objects.requireNonNull(upstreamServerId, "upstreamServerId");
        Objects.requireNonNull(upstreamRepositoryId, "upstreamRepositoryId");
        AoRepositoryMapping[] mappings = (AoRepositoryMapping[])this.ao.find(AoRepositoryMapping.class, Query.select().where("UPSTREAM_ID = ? AND EXTERNAL_ID = ?", new Object[]{upstreamServerId, upstreamRepositoryId}));
        return mappings == null || mappings.length <= 0 ? null : mappings[0];
    }

    @Override
    @Nonnull
    public Iterable<AoRepositoryMapping> getByUpstreamId(@Nonnull String upstreamServerId, @Nonnull Iterable<String> upstreamRepositoryIds) {
        Objects.requireNonNull(upstreamServerId, "upstreamServerId");
        Objects.requireNonNull(upstreamRepositoryIds, "upstreamRepositoryIds");
        ArrayList<AoRepositoryMapping> mappings = new ArrayList<AoRepositoryMapping>();
        Iterable batches = Iterables.partition(upstreamRepositoryIds, (int)100);
        for (List batch : batches) {
            StringBuilder whereClause = new StringBuilder();
            ArrayList<String> arguments = new ArrayList<String>();
            whereClause.append("UPSTREAM_ID = ? ");
            arguments.add(upstreamServerId);
            whereClause.append("AND EXTERNAL_ID IN (");
            whereClause.append(MappingDaoHelper.inClausePlaceholder(batch));
            whereClause.append(")");
            arguments.addAll(batch);
            AoRepositoryMapping[] aoRepositoryMappings = (AoRepositoryMapping[])this.ao.find(AoRepositoryMapping.class, Query.select().where(whereClause.toString(), arguments.toArray()).order("LOCAL_ID ASC"));
            Collections.addAll(mappings, aoRepositoryMappings);
        }
        return mappings;
    }

    @Override
    @Nonnull
    public Set<String> getExternalIdsByLocalProjectId(int localProjectId) {
        HashSet<String> externalRepositoryIds = new HashSet<String>();
        this.ao.stream(AoRepositoryMapping.class, Query.select((String)Joiner.on((char)',').join((Object)"LOCAL_ID", (Object)"EXTERNAL_ID", new Object[0])).where("PROJECT_ID = ?", new Object[]{localProjectId}), repoMapping -> externalRepositoryIds.add(repoMapping.getExternalId()));
        return externalRepositoryIds;
    }

    @Override
    public Optional<Date> getLastSyncDate() {
        AoRepositoryMapping[] result = (AoRepositoryMapping[])this.ao.find(AoRepositoryMapping.class, Query.select((String)Joiner.on((String)",").join((Object)"LOCAL_ID", (Object)"LAST_SYNC", new Object[0])).order("LAST_SYNC DESC").limit(1));
        if (result.length == 1) {
            return Optional.ofNullable(result[0].getLastSyncDate());
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Set<Integer> getLocalProjectIdsByUpstreamId(String upstreamId) {
        HashSet<Integer> localProjectIds = new HashSet<Integer>();
        this.ao.stream(AoRepositoryMapping.class, Query.select((String)Joiner.on((char)',').join((Object)"LOCAL_ID", (Object)"PROJECT_ID", new Object[0])).where("UPSTREAM_ID = ?", new Object[]{upstreamId}), repoMapping -> localProjectIds.add(repoMapping.getLocalProjectId()));
        return localProjectIds;
    }

    @Override
    public int incrementFailedSyncCount(int localId) {
        Object[] mappings = (AoRepositoryMapping[])this.ao.find(AoRepositoryMapping.class, Query.select().where("LOCAL_ID = ?", new Object[]{localId}));
        if (ArrayUtils.isEmpty((Object[])mappings)) {
            return 0;
        }
        Object mapping = mappings[0];
        Integer failedSyncCount = mapping.getFailedSyncCount();
        int newCount = (failedSyncCount == null ? 0 : failedSyncCount) + 1;
        mapping.setFailedSyncCount(newCount);
        mapping.save();
        return newCount;
    }

    @Override
    @Nonnull
    public Map<String, Integer> mapIds() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.ao.stream(AoRepositoryMapping.class, Query.select((String)Joiner.on((char)',').join((Object)"EXTERNAL_ID", (Object)"LOCAL_ID", new Object[0])), repoMapping -> builder.put((Object)repoMapping.getExternalId(), (Object)repoMapping.getLocalId()));
        return builder.build();
    }

    @Override
    @Nonnull
    public Map<String, Integer> mapIdsForLocalProject(int localProjectId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.ao.stream(AoRepositoryMapping.class, Query.select((String)Joiner.on((char)',').join((Object)"EXTERNAL_ID", (Object)"LOCAL_ID", new Object[0])).where("PROJECT_ID = ?", new Object[]{localProjectId}), repoMapping -> builder.put((Object)repoMapping.getExternalId(), (Object)repoMapping.getLocalId()));
        return builder.build();
    }

    @Override
    public AoRepositoryMapping updateProject(int localId, int localProjectId) {
        return this.update(localId, mapping -> mapping.setLocalProjectId(localProjectId));
    }

    @Override
    public AoRepositoryMapping updateSyncDate(int localId, @Nonnull Date date) {
        Objects.requireNonNull(date, "date");
        return this.update(localId, mapping -> {
            if (mapping.getInitialSyncDate() == null) {
                mapping.setInitialSyncDate(date);
            }
            mapping.setLastSyncDate(date);
            mapping.setFailedSyncCount(0);
        });
    }

    private AoRepositoryMapping update(int localId, Consumer<AoRepositoryMapping> action) {
        Object[] mappings = (AoRepositoryMapping[])this.ao.find(AoRepositoryMapping.class, Query.select().where("LOCAL_ID = ?", new Object[]{localId}));
        if (ArrayUtils.isEmpty((Object[])mappings)) {
            log.debug("Update failed for mapping for repository with ID [{}]: mapping not found", (Object)localId);
            return null;
        }
        action.accept((AoRepositoryMapping)mappings[0]);
        mappings[0].save();
        return mappings[0];
    }
}

