/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamInstallationParameters;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoMirroredProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoUpstreamSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.CreateUpstreamServerRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.MappingDaoHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.UpstreamServerDao;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.MirroringMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AoUpstreamServerDao
extends AbstractAoDao
implements UpstreamServerDao {
    static final MirroringMode DEFAULT_MODE = MirroringMode.SELECTED_PROJECTS;
    private static final Pattern TAILING_SLASHES = Pattern.compile("/+$");

    @Autowired
    public AoUpstreamServerDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public AoUpstreamServer create(@Nonnull CreateUpstreamServerRequest request) {
        Objects.requireNonNull(request, "request");
        String baseUrl = AoUpstreamServerDao.cleanUrl(request.getBaseUrl());
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"BASE_URL", (Object)baseUrl).put((Object)"ID", (Object)request.getId()).put((Object)"LAST_STATE_CHANGE_DATE", (Object)new Date()).put((Object)"STATE", (Object)request.getState());
        AoUpstreamServer upstream = (AoUpstreamServer)this.ao.create(AoUpstreamServer.class, (Map)builder.build());
        this.ao.create(AoUpstreamSettings.class, (Map)ImmutableMap.builder().put((Object)"UPSTREAM_ID", (Object)upstream.getId()).put((Object)"MODE", (Object)DEFAULT_MODE.getId()).build());
        return upstream;
    }

    @Override
    public AoUpstreamServer getByIssuerId(@Nonnull String issuerId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)issuerId), (Object)"issuerId");
        AoUpstreamServer[] sources = (AoUpstreamServer[])this.ao.find(AoUpstreamServer.class, Query.select().where("ISSUER_ID = ?", new Object[]{issuerId}).limit(1));
        return sources != null && sources.length > 0 ? sources[0] : null;
    }

    @Override
    public AoUpstreamServer getById(@Nonnull String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"id");
        return (AoUpstreamServer)this.ao.get(AoUpstreamServer.class, (Object)id);
    }

    @Override
    public AoUpstreamSettings getSettingsById(@Nonnull String upstreamId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)upstreamId), (Object)"upstreamId");
        return (AoUpstreamSettings)this.ao.get(AoUpstreamSettings.class, (Object)upstreamId);
    }

    @Override
    public AoUpstreamServer getUpstream() {
        Object[] results = (AoUpstreamServer[])this.ao.find(AoUpstreamServer.class);
        return ArrayUtils.isEmpty((Object[])results) ? null : results[0];
    }

    @Override
    public boolean isDiscovering(@Nonnull String upstreamId) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        AoUpstreamServer upstream = this.getById(upstreamId);
        if (upstream == null) {
            return false;
        }
        AoUpstreamSettings settings = this.getSettingsById(upstreamId);
        if (settings == null) {
            return false;
        }
        MirroringMode mode = MirroringMode.fromId(settings.getMode());
        if (mode == MirroringMode.ALL_PROJECTS) {
            Date lastSettingsChangeDate = upstream.getLastSettingsChangeDate();
            Date lastFullSyncDate = upstream.getLastFullSyncDate();
            return lastSettingsChangeDate != null && (lastFullSyncDate == null || lastFullSyncDate.before(lastSettingsChangeDate));
        }
        return this.countMirroredProjectsInProgress(upstreamId) > 0;
    }

    @Override
    public void setInitialSyncDateForProjects(@Nonnull String upstreamServerId, @Nonnull Set<String> externalIds, @Nonnull Date initialSyncDate) {
        Objects.requireNonNull(upstreamServerId, "upstreamServerId");
        Objects.requireNonNull(externalIds, "externalIds");
        Objects.requireNonNull(initialSyncDate, "initialSyncDate");
        ArrayList projects = new ArrayList();
        Iterable batches = Iterables.partition(externalIds, (int)100);
        for (List batch : batches) {
            StringBuilder whereClause = new StringBuilder();
            ArrayList<String> arguments = new ArrayList<String>();
            whereClause.append("UPSTREAM_SETTINGS_ID = ? ");
            arguments.add(upstreamServerId);
            whereClause.append("AND INITIAL_SYNC IS NULL ");
            whereClause.append("AND EXTERNAL_ID IN (");
            whereClause.append(MappingDaoHelper.inClausePlaceholder(batch));
            whereClause.append(")");
            arguments.addAll(batch);
            AoMirroredProject[] aoRepositoryMappings = (AoMirroredProject[])this.ao.find(AoMirroredProject.class, Query.select().where(whereClause.toString(), arguments.toArray()).order("ID ASC"));
            Collections.addAll(projects, aoRepositoryMappings);
        }
        projects.forEach(project -> {
            project.setInitialSyncDate(initialSyncDate);
            project.save();
        });
    }

    @Override
    public AoUpstreamServer setInstalledParameters(@Nonnull UpstreamInstallationParameters parameters) {
        Objects.requireNonNull(parameters, "parameters");
        AoUpstreamServer upstream = this.getUpstream();
        if (upstream == null) {
            return null;
        }
        upstream.setHandshakeId(parameters.getHandshakeId());
        upstream.setIssuerId(parameters.getIssuerId());
        upstream.setSharedSecret(parameters.getSecret());
        upstream.save();
        return upstream;
    }

    @Override
    public AoUpstreamServer transitionState(@Nonnull String id, @Nonnull IntegrationState state) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(state, "state");
        AoUpstreamServer upstream = this.getById(id);
        if (upstream == null) {
            return null;
        }
        return this.transitionState(upstream, state);
    }

    @Override
    @Nonnull
    public AoUpstreamServer transitionState(@Nonnull AoUpstreamServer upstream, @Nonnull IntegrationState state) {
        Objects.requireNonNull(upstream, "upstream");
        Objects.requireNonNull(state, "state");
        if (upstream.getState() != state) {
            upstream.setLastStateChangeDate(new Date());
        }
        upstream.setState(state);
        upstream.save();
        return upstream;
    }

    @Override
    public AoUpstreamServer setLastFullSyncDate(@Nonnull String id, Date lastFullSyncDate) {
        Objects.requireNonNull(id, "id");
        AoUpstreamServer upstream = this.getById(id);
        if (upstream == null) {
            return null;
        }
        upstream.setLastFullSyncDate(lastFullSyncDate);
        upstream.save();
        return upstream;
    }

    @Override
    public AoUpstreamSettings updateSettings(@Nonnull String upstreamId, MirroringMode mode, @Nonnull List<String> addProjectIds, @Nonnull List<String> removeProjectIds) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)upstreamId), (Object)"upstreamId");
        Objects.requireNonNull(addProjectIds, "addProjectIds");
        Objects.requireNonNull(removeProjectIds, "removeProjectIds");
        AoUpstreamSettings settings = this.getSettingsByUpstreamId(upstreamId);
        if (settings == null) {
            return null;
        }
        if (mode != null) {
            settings.setMode(mode.getId());
            settings.save();
        }
        HashSet<String> projectsToAdd = new HashSet<String>(addProjectIds);
        HashSet<String> projectsToRemove = new HashSet<String>(removeProjectIds);
        projectsToAdd.removeAll(projectsToRemove);
        for (AoMirroredProject mirroredProject : settings.getMirroredProjects()) {
            if (projectsToRemove.remove(mirroredProject.getExternalId())) {
                this.ao.delete(new RawEntity[]{mirroredProject});
                continue;
            }
            projectsToAdd.remove(mirroredProject.getExternalId());
        }
        projectsToAdd.forEach(projectId -> this.ao.create(AoMirroredProject.class, (Map)ImmutableMap.builder().put((Object)"UPSTREAM_SETTINGS_ID", (Object)upstreamId).put((Object)"EXTERNAL_ID", projectId).build()));
        settings.save();
        return this.getSettingsByUpstreamId(upstreamId);
    }

    @Override
    public AoUpstreamSettings updateSettings(@Nonnull String upstreamId, @Nonnull MirroringMode mode, @Nonnull List<String> externalProjectIds) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)upstreamId), (Object)"upstreamId");
        Objects.requireNonNull(mode, "mode");
        Objects.requireNonNull(externalProjectIds, "externalProjectIds");
        AoUpstreamSettings settings = this.getSettingsByUpstreamId(upstreamId);
        if (settings == null) {
            return null;
        }
        settings.setMode(mode.getId());
        settings.save();
        HashSet<String> projectsToAdd = new HashSet<String>(externalProjectIds);
        for (AoMirroredProject mirroredProject : settings.getMirroredProjects()) {
            if (projectsToAdd.remove(mirroredProject.getExternalId())) continue;
            this.ao.delete(new RawEntity[]{mirroredProject});
        }
        for (String projectId : projectsToAdd) {
            this.ao.create(AoMirroredProject.class, (Map)ImmutableMap.builder().put((Object)"UPSTREAM_SETTINGS_ID", (Object)upstreamId).put((Object)"EXTERNAL_ID", (Object)projectId).build());
        }
        return this.getSettingsByUpstreamId(upstreamId);
    }

    private static String cleanUrl(String url) {
        if (url == null) {
            return null;
        }
        return TAILING_SLASHES.matcher(url).replaceFirst("");
    }

    private int countMirroredProjectsInProgress(@Nonnull String upstreamServerId) {
        Objects.requireNonNull(upstreamServerId, "upstreamServerId");
        return this.ao.count(AoMirroredProject.class, Query.select().where("INITIAL_SYNC IS NULL AND UPSTREAM_SETTINGS_ID = ?", new Object[]{upstreamServerId}));
    }

    private AoUpstreamSettings getSettingsByUpstreamId(String upstreamId) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        AoUpstreamSettings[] settings = (AoUpstreamSettings[])this.ao.find(AoUpstreamSettings.class, Query.select().where("UPSTREAM_ID = ?", new Object[]{upstreamId}));
        return settings != null && settings.length > 0 ? settings[0] : null;
    }
}

