/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao;

import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CreateUpstreamServerRequest {
    private final String baseUrl;
    private final String id;
    private final IntegrationState state;

    private CreateUpstreamServerRequest(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.id = builder.id;
        this.state = builder.state;
    }

    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public IntegrationState getState() {
        return this.state;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseUrl", (Object)this.baseUrl).add("id", (Object)this.id).add("state", (Object)this.state).toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUpstreamServerRequest that = (CreateUpstreamServerRequest)o;
        return Objects.equals(this.baseUrl, that.baseUrl) && Objects.equals(this.id, that.id) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseUrl, this.id, this.state});
    }

    public static class Builder {
        private String baseUrl;
        private String id;
        private IntegrationState state;

        @Nonnull
        public Builder baseUrl(@Nonnull String value) {
            this.baseUrl = Builder.stripAndEnsureNotBlank(value, "value");
            return this;
        }

        @Nonnull
        public Builder id(@Nonnull String value) {
            this.id = Builder.stripAndEnsureNotBlank(value, "value");
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull IntegrationState value) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value = null");
            this.state = value;
            return this;
        }

        @Nonnull
        public CreateUpstreamServerRequest build() {
            Preconditions.checkState((this.state != null ? 1 : 0) != 0, (Object)"state is null");
            Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"id is blank");
            Preconditions.checkState((this.baseUrl != null ? 1 : 0) != 0, (Object)"baseUrl is blank");
            return new CreateUpstreamServerRequest(this);
        }

        private static String stripAndEnsureNotBlank(String argument, String name) {
            Preconditions.checkArgument(((argument = StringUtils.stripToNull((String)argument)) != null ? 1 : 0) != 0, (Object)(name + " is blank"));
            return argument;
        }
    }
}

