/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v0.AoMirroredProjectV0;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v0.AoProjectMappingV0;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v0.AoRepositoryMappingV0;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v0.AoUpstreamServerV0;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v0.AoUpstreamSettingsV0;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v0.IntegrationStateV0;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;

public class MigrateUpstreamV0toV1
implements ActiveObjectsUpgradeTask {
    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkArgument((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"This task can only upgrade from version 0 to 1");
        ao.migrateDestructively(new Class[]{AoUpstreamServerV0toV1.class, AoUpstreamSettingsV0.class, AoMirroredProjectV0.class, AoProjectMappingV0.class, AoRepositoryMappingV0.class});
        ao.executeInTransaction(() -> {
            for (AoUpstreamServerV0toV1 server : (AoUpstreamServerV0toV1[])ao.find(AoUpstreamServerV0toV1.class)) {
                server.setType(AoUpstreamServerV0toV1.UpstreamServerTypeV0.BITBUCKET_SERVER);
                server.setApiBaseUrl(server.getBaseUrl());
                if (server.getState() == IntegrationStateV0.ENABLED || server.getState() == IntegrationStateV0.DISABLED) {
                    server.setState(IntegrationStateV0.INSTALLED);
                }
                server.save();
            }
            return null;
        });
    }

    @Table(value="UPSTREAM_SERVER")
    @Preload
    public static interface AoUpstreamServerV0toV1
    extends AoUpstreamServerV0 {
        @Accessor(value="API_URL")
        @StringLength(value=255)
        public String getApiBaseUrl();

        @Accessor(value="PRODUCT_TYPE")
        public UpstreamServerTypeV0 getType();

        @Mutator(value="API_URL")
        public void setApiBaseUrl(@Nonnull String var1);

        @Mutator(value="STATE")
        public void setState(@Nonnull IntegrationStateV0 var1);

        @Mutator(value="PRODUCT_TYPE")
        public void setType(@Nonnull UpstreamServerTypeV0 var1);

        public static enum UpstreamServerTypeV0 {
            BITBUCKET_SERVER;

        }
    }
}

