/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao.v10;

import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Optional;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.RawEntity;
import net.java.ao.schema.Ignore;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;
import net.java.ao.schema.Unique;

@Table(value="UPSTREAM_SERVER")
@Preload
public interface AoUpstreamServerV10
extends RawEntity<String> {
    public static final String BASE_URL_COLUMN = "BASE_URL";
    public static final int DEFAULT_STRING_COLUMN_LENGTH = 64;
    public static final String ID_COLUMN = "ID";
    public static final String ISSUER_ID_COLUMN = "ISSUER_ID";
    public static final String LAST_FULL_SYNC_DATE_COLUMN = "LAST_FULL_SYNC_DATE";
    public static final String LAST_SETTINGS_CHANGE_DATE_COLUMN = "LAST_SETTINGS_CHANGE_DATE";
    public static final String LAST_STATE_CHANGE_DATE_COLUMN = "LAST_STATE_CHANGE_DATE";
    public static final int LONG_STRING_COLUMN_LENGTH = 255;
    public static final String SHARED_SECRET_COLUMN = "SHARED_SECRET";
    public static final String STATE_COLUMN = "STATE";
    public static final String TABLE_NAME = "UPSTREAM_SERVER";

    @Accessor(value="BASE_URL")
    @NotNull
    @StringLength(value=255)
    @Unique
    public String getBaseUrl();

    @NotNull
    @PrimaryKey(value="ID")
    @StringLength(value=64)
    public String getId();

    @Ignore
    @Nonnull
    public Optional<String> getIssuerId();

    @Accessor(value="ISSUER_ID")
    @StringLength(value=64)
    public String getIssuerIdRaw();

    @Accessor(value="LAST_FULL_SYNC_DATE")
    public Date getLastFullSyncDate();

    @Accessor(value="LAST_SETTINGS_CHANGE_DATE")
    public Date getLastSettingsChangeDate();

    @Accessor(value="LAST_STATE_CHANGE_DATE")
    @NotNull
    public Date getLastStateChangeDate();

    @Ignore
    @Nonnull
    public Optional<String> getSharedSecret();

    @Accessor(value="SHARED_SECRET")
    @Indexed
    @StringLength(value=255)
    public String getSharedSecretRaw();

    @Accessor(value="STATE")
    @NotNull
    public IntegrationState getState();

    public void setIssuerId(@Nonnull String var1);

    @Mutator(value="LAST_FULL_SYNC_DATE")
    public void setLastFullSyncDate(@Nullable Date var1);

    @Mutator(value="LAST_SETTINGS_CHANGE_DATE")
    public void setLastSettingsChangeDate(@Nullable Date var1);

    @Mutator(value="LAST_STATE_CHANGE_DATE")
    public void setLastStateChangeDate(@Nonnull Date var1);

    @Mutator(value="SHARED_SECRET")
    public void setSharedSecret(@Nonnull String var1);

    @Mutator(value="STATE")
    public void setState(@Nonnull IntegrationState var1);
}

