/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v1.AoRepositoryMappingV1;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairUpstreamMappingIntegrityV1toV2
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(RepairUpstreamMappingIntegrityV1toV2.class);
    private final RepositoryService repositoryService;
    private final SecurityService securityService;

    public RepairUpstreamMappingIntegrityV1toV2(RepositoryService repositoryService, SecurityService securityService) {
        this.repositoryService = repositoryService;
        this.securityService = securityService;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkArgument((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"1")), (Object)"This task can only upgrade from version 1 to 2");
        log.info("Correcting local project ids for mirror repository mappings");
        this.securityService.withPermission(Permission.ADMIN, "Repair projectId column of AoRepositoryMapping").call(() -> ao.executeInTransaction(() -> {
            Query query = Query.select((String)Joiner.on((char)',').join((Object)"LOCAL_ID", (Object)"EXTERNAL_ID", new Object[]{"UPSTREAM_ID", "PROJECT_ID"}));
            ao.stream(AoRepositoryMappingV1.class, query, repositoryMapping -> {
                Repository repository = this.repositoryService.getById(repositoryMapping.getLocalId().intValue());
                if (repository == null) {
                    log.info("{}: Deleting repository mapping for repository with ID ({}) because the local repository with ID [{}] no longer exists", new Object[]{repositoryMapping.getUpstreamId(), repositoryMapping.getExternalId(), repositoryMapping.getLocalId()});
                    repositoryMapping = (AoRepositoryMappingV1)ao.get(AoRepositoryMappingV1.class, (Object)repositoryMapping.getLocalId());
                    ao.delete(new RawEntity[]{repositoryMapping});
                    return;
                }
                int localProjectId = repository.getProject().getId();
                if (!repositoryMapping.getLocalProjectId().equals(localProjectId)) {
                    log.info("{}: Correcting local project id in the mapping for repository with ID ({})", (Object)repositoryMapping.getUpstreamId(), (Object)repositoryMapping.getExternalId());
                    repositoryMapping = (AoRepositoryMappingV1)ao.get(AoRepositoryMappingV1.class, (Object)repositoryMapping.getLocalId());
                    repositoryMapping.setLocalProjectId(localProjectId);
                    repositoryMapping.save();
                }
            });
            return null;
        }));
    }
}

