/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao.v3;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v0.AoMirroredProjectV0;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v0.AoUpstreamSettingsV0;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v1.AoProjectMappingV1;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v1.AoRepositoryMappingV1;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v1.AoUpstreamServerV1;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.base.Preconditions;
import java.util.Optional;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;

public class MigrateMappingsV2toV3
implements ActiveObjectsUpgradeTask {
    private static final int PAGE_SIZE = 500;
    private final RepositoryService repositoryService;
    private final ProjectService projectService;
    private final SecurityService securityService;

    public MigrateMappingsV2toV3(SecurityService securityService, RepositoryService repositoryService, ProjectService projectService) {
        this.securityService = securityService;
        this.repositoryService = repositoryService;
        this.projectService = projectService;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"3");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkArgument((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"2")), (Object)"This task can only upgrade from version 2 to 3");
        ao.migrate(new Class[]{AoRepositoryMappingV2ToV3.class, AoUpstreamSettingsV0.class, AoMirroredProjectV0.class, AoProjectMappingV2ToV3.class, AoUpstreamServerV1.class});
        this.addRepositoryKey(ao);
        this.addProjectMapping(ao);
    }

    private void addRepositoryKey(ActiveObjects ao) {
        boolean fullPageRetrieved;
        while (fullPageRetrieved = ((Boolean)ao.executeInTransaction(() -> {
            AoRepositoryMappingV2ToV3[] mappings;
            for (AoRepositoryMappingV2ToV3 mapping : mappings = (AoRepositoryMappingV2ToV3[])ao.find(AoRepositoryMappingV2ToV3.class, Query.select().where("EXTERNAL_SLUG IS null", new Object[0]).limit(500))) {
                Optional<String> repo = this.getRepoSlug(mapping.getLocalId());
                if (repo.isPresent()) {
                    mapping.setExternalSlug(repo.get());
                    mapping.save();
                    continue;
                }
                ao.delete(new RawEntity[]{mapping});
            }
            return mappings.length == 500;
        })).booleanValue()) {
        }
    }

    private void addProjectMapping(ActiveObjects ao) {
        boolean fullPageRetrieved;
        while (fullPageRetrieved = ((Boolean)ao.executeInTransaction(() -> {
            AoProjectMappingV2ToV3[] mappings;
            String query = String.format("%s IS NULL OR %s IS NULL", "EXTERNAL_KEY", "EXTERNAL_NAME");
            for (AoProjectMappingV2ToV3 mapping : mappings = (AoProjectMappingV2ToV3[])ao.find(AoProjectMappingV2ToV3.class, Query.select().where(query, new Object[0]).limit(500))) {
                Optional<Project> lookup = this.getProject(mapping.getLocalId());
                if (lookup.isPresent()) {
                    Project project = lookup.get();
                    mapping.setExternalKey(project.getKey());
                    mapping.setExternalName(project.getName());
                    mapping.save();
                    continue;
                }
                ao.delete(new RawEntity[]{mapping});
            }
            return mappings.length == 500;
        })).booleanValue()) {
        }
    }

    private Optional<String> getRepoSlug(int id) {
        return (Optional)this.securityService.withPermission(Permission.ADMIN, "Get repository to update mirroring repository mapping").call(() -> Optional.ofNullable(this.repositoryService.getById(id)).map(Repository::getSlug));
    }

    private Optional<Project> getProject(int id) {
        return (Optional)this.securityService.withPermission(Permission.ADMIN, "Get project to update mirroring project mapping").call(() -> Optional.ofNullable(this.projectService.getById(id)));
    }

    @Table(value="REPO_MAPPING")
    @Preload
    public static interface AoRepositoryMappingV2ToV3
    extends AoRepositoryMappingV1 {
        @Accessor(value="EXTERNAL_SLUG")
        @StringLength(value=255)
        public String getExternalSlug();

        @Mutator(value="EXTERNAL_SLUG")
        public void setExternalSlug(String var1);
    }

    @Table(value="PROJECT_MAPPING")
    @Preload
    public static interface AoProjectMappingV2ToV3
    extends AoProjectMappingV1 {
        @Accessor(value="EXTERNAL_KEY")
        @StringLength(value=255)
        public String getExternalKey();

        @Accessor(value="EXTERNAL_NAME")
        @StringLength(value=255)
        public String getExternalName();

        @Accessor(value="EXTERNAL_KEY")
        public void setExternalKey(String var1);

        @Mutator(value="EXTERNAL_NAME")
        public void setExternalName(String var1);
    }
}

