/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao.v4;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v1.AoUpstreamServerV1;
import com.google.common.base.Preconditions;
import java.util.Date;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.Table;

public class MigrateUpstreamServerV3toV4
implements ActiveObjectsUpgradeTask {
    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"4");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkArgument((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"3")), (Object)"This task can only upgrade from version 3 to 4");
        ao.migrate(new Class[]{NullableAoAoUpstreamServerV1ToV2.class});
        this.addDefaultLastStateChangeDate(ao);
        ao.migrate(new Class[]{AoAoUpstreamServerV1ToV2.class});
    }

    private void addDefaultLastStateChangeDate(ActiveObjects ao) {
        ao.executeInTransaction(() -> {
            NullableAoAoUpstreamServerV1ToV2[] upstreamServers = (NullableAoAoUpstreamServerV1ToV2[])ao.find(NullableAoAoUpstreamServerV1ToV2.class);
            Date now = new Date();
            for (NullableAoAoUpstreamServerV1ToV2 upstreamServer : upstreamServers) {
                upstreamServer.setLastStateChangeDate(now);
                upstreamServer.save();
            }
            return null;
        });
    }

    @Table(value="UPSTREAM_SERVER")
    @Preload
    public static interface NullableAoAoUpstreamServerV1ToV2
    extends AoUpstreamServerV1 {
        @Accessor(value="LAST_STATE_CHANGE_DATE")
        public Date getLastStateChangeDate();

        @Mutator(value="LAST_STATE_CHANGE_DATE")
        public void setLastStateChangeDate(Date var1);
    }

    @Table(value="UPSTREAM_SERVER")
    @Preload
    public static interface AoAoUpstreamServerV1ToV2
    extends AoUpstreamServerV1 {
        @Accessor(value="LAST_STATE_CHANGE_DATE")
        @NotNull
        public Date getLastStateChangeDate();

        @Mutator(value="LAST_STATE_CHANGE_DATE")
        public void setLastStateChangeDate(Date var1);
    }
}

