/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao.v5;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoMirroredProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v0.AoMirroredProjectV0;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v1.AoUpstreamServerV1;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.schema.Table;

public class MigrateUpstreamServerMirroredProjectV4toV5
implements ActiveObjectsUpgradeTask {
    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"5");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkArgument((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"4")), (Object)"This task can only upgrade from version 4 to 5");
        ao.migrate(new Class[]{AoMirroredProjectV4ToV5.class});
        ao.executeInTransaction(() -> {
            Optional<AoUpstreamServerV1> upstream = Arrays.stream((AoUpstreamServerV1[])ao.find(AoUpstreamServerV1.class)).findFirst();
            if (upstream.isPresent()) {
                Date lastFullSync = upstream.get().getLastFullSyncDate();
                Arrays.stream((AoMirroredProject[])ao.find(AoMirroredProject.class)).forEach(project -> {
                    project.setInitialSyncDate(lastFullSync);
                    project.save();
                });
            }
            return null;
        });
    }

    @Table(value="MIRRORED_PROJECT")
    @Preload
    public static interface AoMirroredProjectV4ToV5
    extends AoMirroredProjectV0 {
        @Accessor(value="INITIAL_SYNC")
        public Date getInitialSyncDate();

        @Mutator(value="INITIAL_SYNC")
        public void setInitialSyncDate(Date var1);
    }
}

