/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.dao.v9;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.v8.AoUpstreamServerV8;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.SshKeyStore;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetRemovedStateForUpstreamServerV8toV9
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(SetRemovedStateForUpstreamServerV8toV9.class);
    private final SshKeyStore sshKeyStore;

    public SetRemovedStateForUpstreamServerV8toV9(SshKeyStore sshKeyStore) {
        this.sshKeyStore = sshKeyStore;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"9");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkArgument((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"8")), (Object)"This task can only upgrade from version 8 to 9");
        AoUpstreamServerV8 upstreamServer = this.getUpstreamServer(ao);
        if (upstreamServer == null) {
            return;
        }
        upstreamServer.setState(IntegrationState.REMOVED);
        upstreamServer.setLastStateChangeDate(new Date());
        upstreamServer.save();
        this.sshKeyStore.delete(upstreamServer.getId());
        log.info("Set the upstream state to REMOVED and deleted the SSH key");
    }

    private AoUpstreamServerV8 getUpstreamServer(ActiveObjects ao) {
        Object[] results = (AoUpstreamServerV8[])ao.find(AoUpstreamServerV8.class);
        return ArrayUtils.isEmpty((Object[])results) ? null : results[0];
    }
}

