/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.dmz.mirror.SynchronizationState;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MetadataSynchronizer;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.RepositoriesPostSetupSynchronizer;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.RepositoryMetadataSynchronizedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.MetadataSynchronizationResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.RepositoriesSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncContext;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SynchronizationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SynchronizationHelperFactory;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BulkRepositoryMetadataSynchronizationOperation
implements MirrorOperation<RepositoriesSynchronizationRequest, MetadataSynchronizationResponse> {
    private static final Logger log = LoggerFactory.getLogger(BulkRepositoryMetadataSynchronizationOperation.class);
    private final EventPublisher eventPublisher;
    private final Set<String> inflightProjects;
    private final MirrorRepositoryService mirrorRepositoryService;
    private final DmzMirrorFarm mirrorFarm;
    private final RepositoriesPostSetupSynchronizer repositoriesPostSetupSynchronizer;
    private final MetadataSynchronizer metadataSynchronizer;
    private final SynchronizationHelperFactory synchronizationHelperFactory;
    private final InternalUpstreamService upstreamService;

    public BulkRepositoryMetadataSynchronizationOperation(EventPublisher eventPublisher, MirrorRepositoryService mirrorRepositoryService, DmzMirrorFarm mirrorFarm, RepositoriesPostSetupSynchronizer repositoriesPostSetupSynchronizer, MetadataSynchronizer metadataSynchronizer, SynchronizationHelperFactory synchronizationHelperFactory, InternalUpstreamService upstreamService) {
        this.eventPublisher = eventPublisher;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.mirrorFarm = mirrorFarm;
        this.repositoriesPostSetupSynchronizer = repositoriesPostSetupSynchronizer;
        this.metadataSynchronizer = metadataSynchronizer;
        this.synchronizationHelperFactory = synchronizationHelperFactory;
        this.upstreamService = upstreamService;
        this.inflightProjects = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public MetadataSynchronizationResponse perform(@Nonnull RepositoriesSynchronizationRequest request) {
        String projectId = request.isFullSync() ? "FULL_SYNC" : request.getExternalProjectId();
        AtomicReference<MetadataSynchronizationResponse> result = new AtomicReference<MetadataSynchronizationResponse>(new MetadataSynchronizationResponse(true, (Set<String>)ImmutableSet.of()));
        if (this.inflightProjects.add(projectId)) {
            try {
                result.set(this.processSyncRequest(request));
            }
            finally {
                this.inflightProjects.remove(projectId);
            }
        } else {
            log.debug("Sync is already in flight for project {}, skipping request", (Object)projectId);
        }
        return result.get();
    }

    private static void addRepositoryIdsFor(List<ExternalRepository> allExternalIdsSeen, ExternalRepository externalRepository) {
        externalRepository.getOrigin().ifPresent(orig -> BulkRepositoryMetadataSynchronizationOperation.addRepositoryIdsFor(allExternalIdsSeen, orig));
        allExternalIdsSeen.add(externalRepository);
    }

    private Stream<ExternalRepository> streamRepositories(RepositoriesSynchronizationRequest request) {
        return request.isFullSync() ? this.mirrorRepositoryService.getRepositories() : this.mirrorRepositoryService.getRepositoriesByProjectId(request.getExternalProjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataSynchronizationResponse processSyncRequest(RepositoriesSynchronizationRequest request) {
        Date startDate = new Date();
        InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
        log.debug("{}: Synchronizing upstream repositories", MirrorDescriptionUtils.describe(upstream));
        SynchronizationHelper synchronizationHelper = this.synchronizationHelperFactory.create(request);
        SyncContext syncContext = new SyncContext(upstream, repositoryId -> request.getSyncLevel());
        Object syncRepositories = ImmutableSet.of();
        try {
            syncRepositories = this.syncRepositories(request, syncContext, upstream, startDate, synchronizationHelper);
            MetadataSynchronizationResponse metadataSynchronizationResponse = new MetadataSynchronizationResponse(true, (Set<String>)syncRepositories);
            return metadataSynchronizationResponse;
        }
        catch (RuntimeException e) {
            synchronizationHelper.notifySynchronizationFailed(this, upstream, startDate, e);
            MetadataSynchronizationResponse metadataSynchronizationResponse = new MetadataSynchronizationResponse(false, (Set<String>)syncRepositories);
            return metadataSynchronizationResponse;
        }
        finally {
            this.eventPublisher.publish((Object)new RepositoryMetadataSynchronizedEvent(this, (Set<String>)ImmutableSet.copyOf((Collection)syncRepositories)));
        }
    }

    private HashSet<String> syncRepositories(RepositoriesSynchronizationRequest request, SyncContext syncContext, UpstreamServer upstream, Date startDate, SynchronizationHelper synchronizationHelper) {
        HashSet<String> allExternalRepoIdsSeen = new HashSet<String>();
        HashSet<String> externalProjectIdsSynced = new HashSet<String>();
        this.streamRepositories(request).forEach(externalRepository -> {
            ArrayList<ExternalRepository> repositoryChain = new ArrayList<ExternalRepository>();
            BulkRepositoryMetadataSynchronizationOperation.addRepositoryIdsFor(repositoryChain, externalRepository);
            repositoryChain.forEach(r -> {
                if (!allExternalRepoIdsSeen.contains(r.getId()) && this.metadataSynchronizer.synchronizeRepository((ExternalRepository)r, syncContext) != null) {
                    allExternalRepoIdsSeen.add(r.getId());
                    externalProjectIdsSynced.add(externalRepository.getProject().getId());
                }
            });
        });
        LinkedHashSet<String> syncedRepoIds = new LinkedHashSet<String>(syncContext.getSyncedExternalRepositoryIds());
        SyncResult syncResult = new SyncResult(allExternalRepoIdsSeen, syncedRepoIds, synchronizationHelper.getAllLocallyKnownExternalRepositoryIds(upstream), externalProjectIdsSynced);
        log.debug("{}: Finished first attempt of synchronizing upstream repositories", MirrorDescriptionUtils.describe(upstream));
        syncedRepoIds.addAll(this.repositoriesPostSetupSynchronizer.synchronize(request, syncResult, upstream));
        synchronizationHelper.notifySynchronizationComplete(upstream, request, startDate, syncResult);
        log.debug("{}: Finished synchronizing upstream repositories", MirrorDescriptionUtils.describe(upstream));
        if (!syncedRepoIds.isEmpty()) {
            this.mirrorFarm.compareAndSetSynchronizationState(SynchronizationState.BOOTSTRAPPED, SynchronizationState.METADATA_SYNCHRONIZED);
        }
        return syncedRepoIds;
    }
}

