/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorSetupHelper;
import com.atlassian.bitbucket.dmz.mirror.DmzSecretService;
import com.atlassian.bitbucket.dmz.mirror.SynchronizationState;
import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.SimpleInternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamInstallationParameters;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.SyncCredentialsManager;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.UpstreamAuthenticationState;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.InitialSyncHelper;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.MirrorInstalledUpstreamEvent;
import com.atlassian.bitbucket.mirroring.mirror.MirrorPendingInstallUpstreamEvent;
import com.atlassian.bitbucket.mirroring.mirror.MirrorRemovedUpstreamEvent;
import com.atlassian.bitbucket.mirroring.mirror.MirrorStateUpstreamUnknownEvent;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventListener;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class FarmEventManager
implements DisposableBean {
    private static final int FULL_SYNC_DELAY_SECONDS = 10;
    private static final Logger log = LoggerFactory.getLogger(FarmEventManager.class);
    private final ScheduledExecutorService executorService;
    private final DmzMirrorSetupHelper farmMemberSetupHelper;
    private final Consumer<UpstreamAuthenticationState> farmStateChangeListener;
    private final InitialSyncHelper initialSyncHelper;
    private final DmzMirrorFarm mirrorFarm;
    private final ApplicationPropertiesService propertiesService;
    private final DmzSecretService secretService;
    private final SyncCredentialsManager syncCredentialsManager;
    private final InternalUpstreamService upstreamService;
    private final UpstreamSettingsService upstreamSettingsService;
    private final UpstreamUserHelper upstreamUserHelper;
    private String farmStateChangeSubscriptionId;

    public FarmEventManager(DmzSecretService secretService, ApplicationPropertiesService propertiesService, DmzMirrorSetupHelper farmMemberSetupHelper, InternalUpstreamService upstreamService, @Qualifier(value="scheduledExecutorService") ScheduledExecutorService executorService, UpstreamUserHelper upstreamUserHelper, UpstreamSettingsService upstreamSettingsService, InitialSyncHelper initialSyncHelper, DmzMirrorFarm mirrorFarm, SyncCredentialsManager syncCredentialsManager) {
        this.executorService = executorService;
        this.secretService = secretService;
        this.initialSyncHelper = initialSyncHelper;
        this.mirrorFarm = mirrorFarm;
        this.propertiesService = propertiesService;
        this.upstreamService = upstreamService;
        this.farmMemberSetupHelper = farmMemberSetupHelper;
        this.syncCredentialsManager = syncCredentialsManager;
        this.upstreamUserHelper = upstreamUserHelper;
        this.upstreamSettingsService = upstreamSettingsService;
        this.farmStateChangeListener = this::onFarmAuthenticationStateChanged;
    }

    public void destroy() {
        this.secretService.unregisterChangeListener(this.farmStateChangeSubscriptionId);
    }

    @EventListener
    public void onMirrorBootstrapped(MirrorBootstrappedEvent ignored) {
        this.farmStateChangeSubscriptionId = this.secretService.registerChangeListener("mirror.secrets.map.farm.state", this.farmStateChangeListener);
    }

    @EventListener
    public void onMirrorInstalled(MirrorInstalledUpstreamEvent mirrorInstalledUpstreamEvent) {
        this.updateFarmState((InternalUpstreamServer)mirrorInstalledUpstreamEvent.getUpstream());
    }

    @EventListener
    public void onMirrorPending(MirrorPendingInstallUpstreamEvent mirrorPendingInstallUpstreamEvent) {
        this.updateFarmState((InternalUpstreamServer)mirrorPendingInstallUpstreamEvent.getUpstream());
    }

    @EventListener
    public void onMirrorRemoved(MirrorRemovedUpstreamEvent mirrorRemovedUpstreamEvent) {
        this.updateFarmState((InternalUpstreamServer)mirrorRemovedUpstreamEvent.getUpstream());
    }

    @EventListener
    public void onMirrorUnknown(MirrorStateUpstreamUnknownEvent mirrorStateUpstreamUnknownEvent) {
        this.updateFarmState((InternalUpstreamServer)mirrorStateUpstreamUnknownEvent.getUpstream());
    }

    private void maybeTriggerFullSync(InternalUpstreamServer previousUpstreamServer, InternalUpstreamServer currentUpstreamServer) {
        if (previousUpstreamServer == null) {
            return;
        }
        IntegrationState newState = currentUpstreamServer.getState();
        if (previousUpstreamServer.getState() == newState) {
            log.trace("Not triggering full sync as the state '{}' hasn't changed", (Object)newState);
            return;
        }
        this.executorService.schedule(() -> {
            String upstreamId = currentUpstreamServer.getId();
            this.upstreamUserHelper.performAsUpstreamUser(upstreamId, () -> {
                Optional<UpstreamSettings> upstreamSettings = this.upstreamSettingsService.getSettings(upstreamId);
                if (upstreamSettings.isPresent()) {
                    SynchronizationState synchronizationState = this.mirrorFarm.getSynchronizationState();
                    if (synchronizationState == SynchronizationState.METADATA_SYNCHRONIZED || synchronizationState == SynchronizationState.SYNCHRONIZED) {
                        log.trace("Not triggering full sync as the mirror farm is in {} state", (Object)synchronizationState);
                        return null;
                    }
                    log.info("Upstream is now in {} state, triggering full sync", (Object)newState);
                    this.initialSyncHelper.triggerFullSync();
                }
                return null;
            });
        }, 10L, TimeUnit.SECONDS);
    }

    private void onFarmAuthenticationStateChanged(UpstreamAuthenticationState message) {
        if (message == null) {
            log.warn("Lost farm authentication state");
            return;
        }
        InternalUpstreamServer previousUpstreamServer = this.upstreamService.get();
        SimpleInternalUpstreamServer sharedUpstream = message.getUpstreamServer();
        IntegrationState updatedState = sharedUpstream.getState();
        switch (updatedState) {
            case UNKNOWN: 
            case INSTALLED: {
                this.upstreamService.upsertUpstream(sharedUpstream);
                this.upstreamService.overrideUpstreamInstallationParameters(UpstreamInstallationParameters.builder().issuerId(sharedUpstream.getIssuerId().orElse("")).secret(sharedUpstream.getSharedSecret().orElse("")).build());
                this.maybeTriggerFullSync(previousUpstreamServer, sharedUpstream);
                break;
            }
            case INITIALIZING: 
            case PENDING: {
                this.upstreamService.upsertUpstream(sharedUpstream);
                break;
            }
            case REMOVED: {
                this.upstreamService.upsertUpstream(sharedUpstream);
                this.syncCredentialsManager.deleteCredentials(sharedUpstream.getId());
                break;
            }
            default: {
                log.info("Ignoring message with upstream state: {}", (Object)sharedUpstream.getState().getId());
            }
        }
        this.farmMemberSetupHelper.setServerId(message.getServerId());
        this.farmMemberSetupHelper.markAlreadySetup();
    }

    private void updateFarmState(InternalUpstreamServer upstreamServer) {
        String serverId = Objects.requireNonNull(this.propertiesService.getServerId(), "serverId");
        this.secretService.put("mirror.secrets.map.farm.state", (Object)new UpstreamAuthenticationState(serverId, new SimpleInternalUpstreamServer.Builder(upstreamServer).build()));
    }
}

