/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.internal.mirroring.mirror.FarmVet;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorSynchronizationJobRunner;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamSettingsRepairer;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MirrorFarmJobRunner;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.UpstreamSettingRequestWrapper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FullSyncStateManager;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.InitialSyncHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.internal.mirroring.mirror.mdc.StateGeneratingJobRunner;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.UpstreamSettingsSyncRunner;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamService;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.scheduler.JobRunner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FarmJobWiring {
    private final ClusterService clusterService;
    private final DmzMirrorFarm mirrorFarm;

    @Autowired
    public FarmJobWiring(ClusterService clusterService, DmzMirrorFarm mirrorFarm) {
        this.clusterService = clusterService;
        this.mirrorFarm = mirrorFarm;
    }

    @Bean
    public JobRunner mirrorSynchronizationJobRunner(MirroringConfig config, FarmVet farmVet, FullSyncStateManager fullSyncStateManager, InitialSyncHelper initialSyncHelper, InternalUpstreamService upstreamService, UpstreamUserHelper upstreamUserHelper) {
        return new StateGeneratingJobRunner(this.clusterService, new MirrorSynchronizationJobRunner(config, farmVet, fullSyncStateManager, this.mirrorFarm, initialSyncHelper, upstreamService, upstreamUserHelper));
    }

    @Bean
    public JobRunner upstreamSettingsSyncRunner(LockService lockService, UpstreamService upstreamService, UpstreamSettingsRepairer upstreamSettingsRepairer, RequestReplyTopic<UpstreamSettingRequestWrapper, UpstreamSettings> upstreamSettingsTopic) {
        return new MirrorFarmJobRunner(this.clusterService.getInformation(), this.mirrorFarm, new StateGeneratingJobRunner(this.clusterService, new UpstreamSettingsSyncRunner(lockService, upstreamService, upstreamSettingsRepairer, upstreamSettingsTopic)));
    }
}

