/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.RepositoryMetadataSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmQueueProcessor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmRequestLockRetryingProcessor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmRequestRetryingProcessor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmSynchronizationRequestLockRetryingProcessor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RepositoryLockListener;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmOrchestrator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.mdc.FarmRequestStateTransferringProcessor;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.DedupingScheduledExecutor;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.FarmMetadataOrchestrator;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FarmQueueProcessorWiring {
    private final MirroringConfig config;
    private final RepositoryLockListener repositoryLockListener;
    private final ScheduledExecutorService scheduledExecutorService;

    @Autowired
    public FarmQueueProcessorWiring(MirroringConfig config, RepositoryLockListener repositoryLockListener, ScheduledExecutorService scheduledExecutorService) {
        this.config = config;
        this.repositoryLockListener = repositoryLockListener;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Bean
    public FarmQueueProcessor<ExternalProject> projectMetadataQueueProcessor(FarmMetadataOrchestrator farmMetadataOrchestrator, FarmQueue<ExternalProject> projectMetadataQueue) {
        return new FarmRequestStateTransferringProcessor<ExternalProject>(new FarmRequestRetryingProcessor<ExternalProject>(request -> farmMetadataOrchestrator.updateLocalProject((ExternalProject)request.get()), new DedupingScheduledExecutor(this.scheduledExecutorService), projectMetadataQueue, this.config.getMaxQueueAttempts(), this.config.getQueueInitialRetryDelay()));
    }

    @Bean
    public FarmQueueProcessor<FarmSynchronizationRequest> refChangesQueueProcessor(FarmOrchestrator farmOrchestrator, FarmQueue<FarmSynchronizationRequest> refChangesQueue) {
        return new FarmRequestStateTransferringProcessor<FarmSynchronizationRequest>(new FarmRequestRetryingProcessor<FarmSynchronizationRequest>(new FarmSynchronizationRequestLockRetryingProcessor(request -> farmOrchestrator.orchestrateChanges((FarmSynchronizationRequest)request.get()), refChangesQueue, FarmSynchronizationRequest::getExternalRepositoryId, this.repositoryLockListener), new DedupingScheduledExecutor(this.scheduledExecutorService), refChangesQueue, this.config.getMaxQueueAttempts(), this.config.getQueueInitialRetryDelay()));
    }

    @Bean
    public FarmQueueProcessor<RepositoryMetadataSynchronizationRequest> repositoryMetadataQueueProcessor(FarmMetadataOrchestrator farmMetadataOrchestrator, FarmQueue<RepositoryMetadataSynchronizationRequest> repositoryMetadataQueue) {
        return new FarmRequestStateTransferringProcessor<RepositoryMetadataSynchronizationRequest>(new FarmRequestRetryingProcessor<RepositoryMetadataSynchronizationRequest>(new FarmRequestLockRetryingProcessor<RepositoryMetadataSynchronizationRequest>(request -> farmMetadataOrchestrator.synchronizeRepository((RepositoryMetadataSynchronizationRequest)request.get()), repositoryMetadataQueue, request -> request.getMinimalExternalRepository().getId(), this.repositoryLockListener), new DedupingScheduledExecutor(this.scheduledExecutorService), repositoryMetadataQueue, this.config.getMaxQueueAttempts(), this.config.getQueueInitialRetryDelay()));
    }
}

