/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.BulkRepositoryMetadataSynchronizationOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.ProjectMetadataSynchronizationOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.RepositoryDefaultBranchUpdateOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.RepositoryDeleteOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.RepositoryMetadataSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.SingleRepositoryMetadataSynchronizationOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.UpstreamSettingRequestWrapper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.UpstreamSettingsOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmQueuePoller;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmQueueProcessor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeChunk;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeChunkOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.MetadataSynchronizationResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopicFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopicSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.zdu.RollingUpgradeOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.zdu.RollingUpgradeState;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.LocalRepositoryLockOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwnerQuery;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwnerQueryOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwnerResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.DefaultBranchUpdateRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.RepositoriesSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.DelayedSyncRepositoriesQuery;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.DelayedSyncRepositoriesQueryOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.DelayedSyncRepositoriesResult;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.plugin.event.PluginEventManager;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FarmWiring {
    private final MirroringConfig config;
    private final PluginEventManager pluginEventManager;
    private final RequestReplyTopicFactory topicFactory;

    @Autowired
    public FarmWiring(MirroringConfig config, PluginEventManager pluginEventManager, RequestReplyTopicFactory topicFactory) {
        this.config = config;
        this.pluginEventManager = pluginEventManager;
        this.topicFactory = topicFactory;
    }

    @Bean
    public RequestReplyTopic<RepositoriesSynchronizationRequest, MetadataSynchronizationResponse> bulkRepositoryMetadataTopic(BulkRepositoryMetadataSynchronizationOperation bulkRepositoryMetadataSynchronizationOperation) {
        return this.topicFactory.registerTopic(bulkRepositoryMetadataSynchronizationOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getBulkMetadataSyncOperationTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).operationInitialRetryDelay(this.config.getOperationInitialRetryDelay()).operationMaxAttempts(this.config.getMaxOperationAttempts()).maximumInflightOperations(this.config.getMaxInflightOperations()).topicMaxAttempts(this.config.getTopicMaxAttempts()).topicInitialRetryDelay(this.config.getTopicInitialRetryDelay()).name("bulkRepositoryMetadata").build());
    }

    @Bean
    public RequestReplyTopic<String, HashSet<String>> clusterRepositoryLockQuery(LocalRepositoryLockOperation localRepositoryLockOperation) {
        return this.topicFactory.registerTopic(localRepositoryLockOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getRepositoryLockQueryTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).maximumInflightOperations(this.config.getMaxInflightOperations()).name("repositoryLockQuery").build());
    }

    @Bean
    public RequestReplyTopic<DelayedSyncRepositoriesQuery, DelayedSyncRepositoriesResult> delayedSyncRepositoriesTopic(DelayedSyncRepositoriesQueryOperation delayedSyncRepositoriesOperation) {
        return this.topicFactory.registerTopic(delayedSyncRepositoriesOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getDelayedSyncRepositoriesQueryOperationTimeout()).callbackTimeout(this.config.getDelayedSyncRepositoriesQueryOperationTimeout().plusSeconds(10L)).maximumInflightOperations(this.config.getMaxInflightOperations()).name("delayedSyncRepositoriesQuery").build());
    }

    @Bean
    public FarmQueuePoller<ExternalProject> farmProjectMetadataQueuePoller(ClusterService clusterService, FarmQueue<ExternalProject> projectMetadataQueue, @Qualifier(value="projectMetadataQueuePollerExecutor") ExecutorService queuePollerExecutor, FarmQueueProcessor<ExternalProject> projectMetadataQueueProcessor) {
        return new FarmQueuePoller<ExternalProject>(queuePollerExecutor, projectMetadataQueue, 500, clusterService, this.pluginEventManager, projectMetadataQueueProcessor, this.config.getProjectMetadataQueuePollerThreads());
    }

    @Bean
    public FarmQueuePoller<FarmSynchronizationRequest> farmRefChangesQueuePoller(ClusterService clusterService, @Qualifier(value="refChangesQueuePollerExecutor") ExecutorService queuePollerExecutor, FarmQueue<FarmSynchronizationRequest> refChangesQueue, FarmQueueProcessor<FarmSynchronizationRequest> refChangesQueueProcessor) {
        return new FarmQueuePoller<FarmSynchronizationRequest>(queuePollerExecutor, refChangesQueue, 500, clusterService, this.pluginEventManager, refChangesQueueProcessor, this.config.getRepositoryRefChangesQueuePollerThreads());
    }

    @Bean
    public FarmQueuePoller<RepositoryMetadataSynchronizationRequest> farmRepositoryMetadataQueuePoller(ClusterService clusterService, @Qualifier(value="repositoryMetadataQueuePollerExecutor") ExecutorService queuePollerExecutor, FarmQueue<RepositoryMetadataSynchronizationRequest> repositoryMetadataQueue, FarmQueueProcessor<RepositoryMetadataSynchronizationRequest> repositoryMetadataQueueProcessor) {
        return new FarmQueuePoller<RepositoryMetadataSynchronizationRequest>(queuePollerExecutor, repositoryMetadataQueue, 500, clusterService, this.pluginEventManager, repositoryMetadataQueueProcessor, this.config.getRepositoryMetadataQueuePollerThreads());
    }

    @Bean
    public RequestReplyTopic<ExternalProject, Boolean> projectMetadataTopic(ProjectMetadataSynchronizationOperation projectMetadataSynchronizationOperation) {
        return this.topicFactory.registerTopic(projectMetadataSynchronizationOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getProjectMetadataOperationTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).operationInitialRetryDelay(this.config.getOperationInitialRetryDelay()).operationMaxAttempts(this.config.getMaxOperationAttempts()).maximumInflightOperations(this.config.getMaxInflightOperations()).name("projectMetadata").topicMaxAttempts(this.config.getTopicMaxAttempts()).topicInitialRetryDelay(this.config.getTopicInitialRetryDelay()).build());
    }

    @Bean
    public RequestReplyTopic<RefChangeChunk, String> refChangeChunkTopic(RefChangeChunkOperation refChangeChunkOperation) {
        return this.topicFactory.registerTopic(refChangeChunkOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getRefChangeChunkOperationTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).maximumInflightOperations(this.config.getMaxInflightOperations()).name("refChangeChunk").build());
    }

    @Bean
    public RequestReplyTopic<DefaultBranchUpdateRequest, Boolean> repositoryDefaultBranchUpdateTopic(RepositoryDefaultBranchUpdateOperation repositoryDefaultBranchUpdateOperation) {
        return this.topicFactory.registerTopic(repositoryDefaultBranchUpdateOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getRepositoryDefaultBranchOperationTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).operationInitialRetryDelay(this.config.getOperationInitialRetryDelay()).operationMaxAttempts(this.config.getMaxOperationAttempts()).maximumInflightOperations(this.config.getMaxInflightOperations()).name("repositoryDefaultBranchUpdate").topicMaxAttempts(this.config.getTopicMaxAttempts()).topicInitialRetryDelay(this.config.getTopicInitialRetryDelay()).build());
    }

    @Bean
    public RequestReplyTopic<String, Boolean> repositoryDeleteTopic(RepositoryDeleteOperation repositoryDeleteOperation) {
        return this.topicFactory.registerTopic(repositoryDeleteOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getRepositoryDeleteOperationTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).operationInitialRetryDelay(this.config.getOperationInitialRetryDelay()).operationMaxAttempts(this.config.getMaxOperationAttempts()).maximumInflightOperations(this.config.getMaxInflightOperations()).name("repositoryDelete").topicMaxAttempts(this.config.getTopicMaxAttempts()).topicInitialRetryDelay(this.config.getTopicInitialRetryDelay()).build());
    }

    @Bean
    public RequestReplyTopic<RepositoryLockOwnerQuery, RepositoryLockOwnerResult> repositoryLockOwnerQueryTopic(RepositoryLockOwnerQueryOperation lockOwnerOperation) {
        return this.topicFactory.registerTopic(lockOwnerOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getRepositoryLockOwnerQueryOperationTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).operationInitialRetryDelay(this.config.getOperationInitialRetryDelay()).operationMaxAttempts(this.config.getMaxOperationAttempts()).maximumInflightOperations(this.config.getMaxInflightOperations()).name("repositoryLockOwnerQuery").build());
    }

    @Bean
    public Topic<String> repositoryLockReleaseTopic(@Qualifier(value="stateTransferringTopicService") TopicService topicService) {
        return topicService.getTopic("mirror.repository.lock.release.topic", new TopicSettings.Builder(String.class).build());
    }

    @Bean
    public RequestReplyTopic<Boolean, RollingUpgradeState> rollingUpgradeTopic(RollingUpgradeOperation rollingUpgradeOperation) {
        return this.topicFactory.registerTopic(rollingUpgradeOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getRollingUpgradeOperationTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).operationInitialRetryDelay(this.config.getOperationInitialRetryDelay()).operationMaxAttempts(this.config.getMaxOperationAttempts()).maximumInflightOperations(this.config.getMaxInflightOperations()).name("rollingUpgrade").build());
    }

    @Bean
    public RequestReplyTopic<ExternalRepository, Boolean> singleRepositoryMetadataTopic(SingleRepositoryMetadataSynchronizationOperation singleRepositoryMetadataSynchronizationOperation) {
        return this.topicFactory.registerTopic(singleRepositoryMetadataSynchronizationOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getSingleRepositoryMetadataOperationTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).operationInitialRetryDelay(this.config.getOperationInitialRetryDelay()).operationMaxAttempts(this.config.getMaxOperationAttempts()).maximumInflightOperations(this.config.getMaxInflightOperations()).name("singleRepositoryMetadata").topicMaxAttempts(this.config.getTopicMaxAttempts()).topicInitialRetryDelay(this.config.getTopicInitialRetryDelay()).build());
    }

    @Bean
    public RequestReplyTopic<RepositorySynchronizationRequest, RepositorySynchronizationResponse> updateRefTopic(@Qualifier(value="updateRefOperation") RepositorySynchronizationOperation updateRefsOperation) {
        return this.topicFactory.registerTopic(updateRefsOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getUpdateRefsOperationTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).operationInitialRetryDelay(this.config.getOperationInitialRetryDelay()).operationMaxAttempts(this.config.getMaxOperationAttempts()).maximumInflightOperations(this.config.getMaxInflightOperations()).name("updateRef").build());
    }

    @Bean
    public RequestReplyTopic<UpstreamSettingRequestWrapper, UpstreamSettings> upstreamSettingsTopic(UpstreamSettingsOperation upstreamSettingsOperation) {
        return this.topicFactory.registerTopic(upstreamSettingsOperation, new RequestReplyTopicSettings.Builder().operationTimeout(this.config.getUpstreamSettingsOperationTimeout()).callbackTimeout(this.config.getOperationCallbackTimeout()).operationInitialRetryDelay(this.config.getOperationInitialRetryDelay()).operationMaxAttempts(this.config.getMaxOperationAttempts()).maximumInflightOperations(this.config.getMaxInflightOperations()).name("upstreamSettings").build());
    }
}

