/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryLockService;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LockHarvestScheduler
implements LifecycleAware {
    private static final JobId JOB_ID = JobId.of((String)LockHarvestScheduler.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)LockHarvestScheduler.class.getName());
    private static final Logger log = LoggerFactory.getLogger(LockHarvestScheduler.class);
    private final Duration harvestInterval;
    private final MirrorRepositoryLockService mirrorRepositoryLockService;
    private final Topic<String> repositoryLockReleaseTopic;
    private final SchedulerService schedulerService;

    @Autowired
    public LockHarvestScheduler(MirroringConfig mirroringConfig, MirrorRepositoryLockService mirrorRepositoryLockService, Topic<String> repositoryLockReleaseTopic, SchedulerService schedulerService) {
        this.repositoryLockReleaseTopic = repositoryLockReleaseTopic;
        this.schedulerService = schedulerService;
        this.mirrorRepositoryLockService = mirrorRepositoryLockService;
        this.harvestInterval = mirroringConfig.getLockHarvestInterval();
    }

    public void onStart() {
        LockHarvestJobRunner lockHarvestJobRunner = new LockHarvestJobRunner();
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)lockHarvestJobRunner);
        try {
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)this.harvestInterval.toMillis(), (Date)Date.from(ZonedDateTime.now().plus(this.harvestInterval).toInstant()))));
        }
        catch (SchedulerServiceException e) {
            log.warn("Failed to schedule {}", (Object)JOB_RUNNER_KEY, (Object)e);
        }
    }

    public void onStop() {
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private class LockHarvestJobRunner
    implements JobRunner {
        private LockHarvestJobRunner() {
        }

        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            Objects.requireNonNull(request, "request");
            LockHarvestScheduler.this.mirrorRepositoryLockService.harvestStaleLocks(arg_0 -> LockHarvestScheduler.this.repositoryLockReleaseTopic.publish(arg_0));
            return JobRunnerResponse.success();
        }
    }
}

