/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.ConstraintViolationUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.LogUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorProjectService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncContext;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.UnavailableScmException;
import com.atlassian.bitbucket.scm.UnsupportedScmException;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timer;
import com.atlassian.util.profiling.Timers;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolationException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetadataSynchronizer {
    private static final Timer SYNC_PROJECT = Timers.timer((String)(MetadataSynchronizer.class.getName() + ".synchronizeProject"));
    private static final Timer SYNC_REPOSITORY = Timers.timer((String)(MetadataSynchronizer.class.getName() + ".synchronizeRepository"));
    private static final Logger log = LoggerFactory.getLogger(MetadataSynchronizer.class);
    private final MirrorProjectService mirrorProjectService;
    private final MirrorRepositoryService mirrorRepositoryService;
    private final ConcurrentHashMap<String, Project> projectLock;
    private final ConcurrentHashMap<String, Repository> repositoryLock;
    private final ScmService scmService;

    @Autowired
    MetadataSynchronizer(MirrorProjectService mirrorProjectService, MirrorRepositoryService mirrorRepositoryService, ScmService scmService) {
        this.mirrorProjectService = mirrorProjectService;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.scmService = scmService;
        this.projectLock = new ConcurrentHashMap();
        this.repositoryLock = new ConcurrentHashMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Repository synchronizeRepository(@Nonnull ExternalRepository externalRepository, @Nonnull SyncContext syncContext) {
        Objects.requireNonNull(externalRepository, "externalRepository");
        Objects.requireNonNull(syncContext, "syncContext");
        try (Ticker ignored = SYNC_REPOSITORY.start(new String[]{externalRepository.getId()});){
            if (this.scmService.isSupported(externalRepository.getScmId(), ScmFeature.MIRRORS)) {
                AtomicReference repository3 = new AtomicReference();
                this.repositoryLock.compute(externalRepository.getId(), (id, r) -> {
                    repository3.set(syncContext.syncOnce(externalRepository, this::setupLocalRepository));
                    return null;
                });
                Repository repository2 = (Repository)repository3.get();
                return repository2;
            }
            Repository repository = null;
            return repository;
        }
        catch (UnavailableScmException | UnsupportedScmException e) {
            log.debug("{}: failed to prepare local repository: {}", MirrorDescriptionUtils.describe(externalRepository), (Object)MetadataSynchronizer.getExceptionMessage((RuntimeException)e));
            return null;
        }
        catch (RuntimeException e) {
            log.error("{}: failed to prepare local repository: {}", new Object[]{MirrorDescriptionUtils.describe(externalRepository), MetadataSynchronizer.getExceptionMessage(e), LogUtils.logStacktraceIfEnabled(log.isDebugEnabled(), e)});
            return null;
        }
    }

    @Nullable
    public Project synchronizeProject(@Nonnull ExternalProject externalProject, @Nonnull SyncContext syncContext) {
        Project project;
        block8: {
            Objects.requireNonNull(externalProject, "externalProject");
            Objects.requireNonNull(syncContext, "syncContext");
            Ticker ignored = SYNC_PROJECT.start(new String[]{externalProject.getId()});
            try {
                project = syncContext.syncOnce(externalProject, this::setupProjectLocally);
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    log.error("{}: failed to prepare local project: {}", new Object[]{MirrorDescriptionUtils.describe(externalProject), MetadataSynchronizer.getExceptionMessage(e), LogUtils.logStacktraceIfEnabled(log.isDebugEnabled(), e)});
                    return null;
                }
            }
            ignored.close();
        }
        return project;
    }

    private static String getExceptionMessage(RuntimeException e) {
        if (e instanceof ConstraintViolationException) {
            return ConstraintViolationUtils.violationToString((ConstraintViolationException)((Object)e));
        }
        return e.getMessage();
    }

    private Repository setupLocalRepository(ExternalRepository externalRepository, SyncContext syncContext) {
        Optional<Repository> origin = externalRepository.getOrigin().map(orig -> syncContext.syncOnce((ExternalRepository)orig, this::setupLocalRepository));
        ExternalProject externalProject = externalRepository.getProject();
        Project targetProject = syncContext.syncOnce(externalProject, this::setupProjectLocally);
        if (targetProject == null) {
            return null;
        }
        return this.mirrorRepositoryService.syncLocalRepository(externalRepository, targetProject, origin.orElse(null));
    }

    private Project setupProjectLocally(ExternalProject externalProject, SyncContext context) {
        try {
            AtomicReference project = new AtomicReference();
            this.projectLock.compute(externalProject.getId(), (id, p) -> {
                project.set(this.mirrorProjectService.syncLocalProject(externalProject, context.getUpstream(), true));
                return null;
            });
            return (Project)project.get();
        }
        catch (RuntimeException e) {
            log.error("{}: failed to prepare local project: {}", new Object[]{MirrorDescriptionUtils.describe(externalProject), MetadataSynchronizer.getExceptionMessage(e), e});
            return null;
        }
    }
}

