/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.dmz.cluster.ClusterNodeAttributes;
import com.atlassian.bitbucket.dmz.cluster.MirrorClusterNode;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.internal.mirroring.mirror.SyncProgressUpdatedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.RepositoryMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.PackedSyncProgress;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizedEvent;
import com.atlassian.bitbucket.mirroring.mirror.SyncProgress;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorClusterNodeAttributesUpdater
implements LifecycleAware {
    public static final String PROGRESS_ATTRIBUTE = "syncProgress";
    private static final Logger log = LoggerFactory.getLogger(MirrorClusterNodeAttributesUpdater.class);
    private final Supplier<MirrorClusterNode> localNodeSupplier;
    private final AtomicInteger noSendCount = new AtomicInteger(1);
    private final RepositoryMappingDao repositoryMappingDao;
    private final ClusterNodeAttributes clusterNodeAttributes;
    private volatile SyncProgress lastSentSyncProgress;
    private volatile Instant lastSentSynchronizedDate;
    private volatile SyncProgress lastSyncProgress;
    private volatile Instant lastSynchronizedDate;

    public MirrorClusterNodeAttributesUpdater(DmzMirrorFarm mirrorFarm, RepositoryMappingDao repositoryMappingDao, ClusterNodeAttributes clusterNodeAttributes) {
        this.localNodeSupplier = mirrorFarm.getLocalNode();
        this.repositoryMappingDao = repositoryMappingDao;
        this.clusterNodeAttributes = clusterNodeAttributes;
    }

    public void maybeUpdateAttributes() {
        try {
            boolean sent = false;
            if (!Objects.equals(this.lastSentSynchronizedDate, this.lastSynchronizedDate)) {
                sent = true;
                this.lastSentSynchronizedDate = this.lastSynchronizedDate;
                this.sendLastSynchronized();
            }
            if (!Objects.equals(this.lastSentSyncProgress, this.lastSyncProgress)) {
                sent = true;
                this.lastSentSyncProgress = this.lastSyncProgress;
                this.sendSyncProgress();
            }
            if (!sent) {
                if (this.noSendCount.incrementAndGet() >= 100) {
                    this.sendSyncProgress();
                    this.sendLastSynchronized();
                    this.clusterNodeAttributes.sync();
                    this.noSendCount.set(1);
                }
            } else {
                this.noSendCount.set(1);
            }
        }
        catch (Exception e) {
            log.warn("Error updating member node attributes", (Throwable)e);
        }
    }

    @EventListener
    public void onRepositorySynchronizedEvent(@Nonnull RepositorySynchronizedEvent event) {
        Objects.requireNonNull(event, "event");
        this.lastSynchronizedDate = event.getDate().toInstant();
    }

    public void onStart() {
        this.repositoryMappingDao.getLastSyncDate().ifPresent(date -> {
            this.lastSentSynchronizedDate = date.toInstant();
            if (this.lastSentSynchronizedDate != null) {
                this.clusterNodeAttributes.setAttributeLong("farmLastSynchronized", Long.valueOf(this.lastSentSynchronizedDate.toEpochMilli()));
            }
        });
    }

    public void onStop() {
    }

    @EventListener
    public void onSyncProgressUpdated(@Nonnull SyncProgressUpdatedEvent event) {
        Objects.requireNonNull(event, "event");
        this.lastSyncProgress = event.getSyncProgress();
    }

    private void sendLastSynchronized() {
        if (this.lastSynchronizedDate != null) {
            this.clusterNodeAttributes.setAttributeLong("farmLastSynchronized", Long.valueOf(this.lastSentSynchronizedDate.toEpochMilli()));
        }
    }

    private void sendSyncProgress() {
        if (this.lastSyncProgress != null) {
            this.clusterNodeAttributes.setAttributeLong(PROGRESS_ATTRIBUTE, Long.valueOf(new PackedSyncProgress(this.lastSyncProgress).toLong()));
        }
    }
}

