/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.dmz.mirror.ClusterCounter;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorFarmJobRunner
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(MirrorFarmJobRunner.class);
    private final ClusterInformation clusterInformation;
    private final JobRunner delegate;
    private final DmzMirrorFarm mirrorFarm;

    public MirrorFarmJobRunner(@Nonnull ClusterInformation clusterInformation, @Nonnull DmzMirrorFarm mirrorFarm, @Nonnull JobRunner delegate) {
        this.clusterInformation = Objects.requireNonNull(clusterInformation, "clusterInformation");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.mirrorFarm = Objects.requireNonNull(mirrorFarm, "mirrorFarm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        Objects.requireNonNull(request, "request");
        JobId jobId = request.getJobId();
        String counterName = jobId.toString();
        ClusterCounter counter = this.mirrorFarm.getCounter(counterName);
        Set nodes = this.clusterInformation.getNodes();
        int targetNode = (int)(counter.get() % (long)nodes.size());
        if (MirrorFarmJobRunner.sorted(nodes).get(targetNode).isLocal()) {
            try {
                log.trace("{}: Running job using {}", (Object)jobId, (Object)this.delegate);
                JobRunnerResponse jobRunnerResponse = this.delegate.runJob(request);
                return jobRunnerResponse;
            }
            finally {
                counter.increment();
            }
        }
        log.trace("{}: Skipping job", (Object)jobId);
        return JobRunnerResponse.success();
    }

    private static List<ClusterNode> sorted(Set<ClusterNode> nodes) {
        return nodes.stream().sorted(Comparator.comparing(ClusterNode::getId)).collect(Collectors.toList());
    }
}

