/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.dmz.mirror.SynchronizationState;
import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.InitialSyncHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.MirrorJwtTokenHelper;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.MirrorInstalledUpstreamEvent;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsService;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.PluginEventManager;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class MirrorNodeJoinManager
implements InitializingBean,
DisposableBean {
    private static final int FULL_SYNC_DELAY_SECONDS = 10;
    private static final Logger log = LoggerFactory.getLogger(MirrorNodeJoinManager.class);
    private final ScheduledExecutorService executor;
    private final InitialSyncHelper initialSyncHelper;
    private final MirrorJwtTokenHelper jwtTokenHelper;
    private final DmzMirrorFarm mirrorFarm;
    private final PluginEventManager pluginEventManager;
    private final InternalUpstreamService upstreamService;
    private final UpstreamSettingsService upstreamSettingsService;
    private final UpstreamUserHelper upstreamUserHelper;

    public MirrorNodeJoinManager(ScheduledExecutorService executor, InitialSyncHelper initialSyncHelper, PluginEventManager pluginEventManager, InternalUpstreamService upstreamService, UpstreamSettingsService upstreamSettingsService, UpstreamUserHelper upstreamUserHelper, MirrorJwtTokenHelper jwtTokenHelper, DmzMirrorFarm mirrorFarm) {
        this.executor = executor;
        this.initialSyncHelper = initialSyncHelper;
        this.jwtTokenHelper = jwtTokenHelper;
        this.mirrorFarm = mirrorFarm;
        this.pluginEventManager = pluginEventManager;
        this.upstreamService = upstreamService;
        this.upstreamSettingsService = upstreamSettingsService;
        this.upstreamUserHelper = upstreamUserHelper;
    }

    public void afterPropertiesSet() {
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
    }

    @EventListener
    public void onMirrorBootstrapped(MirrorBootstrappedEvent ignored) {
        InternalUpstreamServer upstreamServer = this.upstreamService.get();
        if (upstreamServer == null) {
            log.debug("There was no upstream server found. Settings can't be synced for this mirror");
            return;
        }
        if (EnumSet.of(IntegrationState.INITIALIZING, IntegrationState.PENDING).contains((Object)upstreamServer.getState())) {
            log.debug("The upstream server is in {} state, settings can't be synced for this mirror", (Object)upstreamServer.getState());
            return;
        }
        this.executor.execute(() -> this.upstreamUserHelper.performAsUpstreamUser(upstreamServer.getId(), () -> {
            Optional<UpstreamSettings> upstreamSettings = this.upstreamSettingsService.syncUpstreamSettings(upstreamServer.getId());
            InternalUpstreamServer refreshed = this.upstreamService.get();
            if (refreshed == null) {
                log.debug("Upstream server is not present anymore, not triggering full sync");
                return null;
            }
            if (refreshed.getState() != IntegrationState.INSTALLED) {
                log.debug("Upstream is in {} state, not triggering full sync", (Object)refreshed.getState());
                return null;
            }
            if (upstreamSettings.isPresent()) {
                this.initialSyncHelper.triggerFullSync();
            }
            return null;
        }));
    }

    @EventListener
    public void onMirrorInstalled(MirrorInstalledUpstreamEvent mirrorInstalledUpstreamEvent) {
        this.executor.schedule(() -> {
            UpstreamServer upstream = mirrorInstalledUpstreamEvent.getUpstream();
            this.upstreamUserHelper.performAsUpstreamUser(upstream.getId(), () -> {
                Optional<UpstreamSettings> upstreamSettings = this.upstreamSettingsService.getSettings(upstream.getId());
                if (upstreamSettings.isPresent()) {
                    SynchronizationState synchronizationState = this.mirrorFarm.getSynchronizationState();
                    if (synchronizationState == SynchronizationState.METADATA_SYNCHRONIZED || synchronizationState == SynchronizationState.SYNCHRONIZED) {
                        log.trace("Not triggering full sync as the mirror farm is in {} state", (Object)synchronizationState);
                        return null;
                    }
                    log.info("Upstream is now in {} state, triggering full sync", (Object)upstream.getState());
                    this.jwtTokenHelper.clearCache();
                    this.initialSyncHelper.triggerFullSync();
                }
                return null;
            });
        }, 10L, TimeUnit.SECONDS);
    }
}

