/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.MirrorFarmRefChange;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.SimpleRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public final class MirrorRefHelper {
    private MirrorRefHelper() {
    }

    @Nonnull
    public static Ref toRef(@Nonnull String line) {
        String[] pieces = Objects.requireNonNull(line, "line").split("\t");
        Preconditions.checkArgument((pieces.length == 2 ? 1 : 0) != 0, (String)"%s did not match expected pattern", (Object)line);
        StandardRefType type = StandardRefType.BRANCH;
        GitRefPattern pattern = GitRefPattern.HEADS;
        if (pieces[1].startsWith(GitRefPattern.TAGS.getPath())) {
            pattern = GitRefPattern.TAGS;
            type = StandardRefType.TAG;
        } else if (pieces[1].startsWith(GitRefPattern.PULL_REQUESTS.getPath())) {
            pattern = GitRefPattern.PULL_REQUESTS;
        }
        return ((SimpleRef.Builder)((SimpleRef.Builder)((SimpleRef.Builder)new SimpleRef.Builder().type((RefType)type).latestCommit(pieces[0])).id(pieces[1])).displayId(pattern.unqualify(pieces[1]))).build();
    }

    @Nonnull
    public static MirrorFarmRefChange toRefChange(@Nonnull String line, @Nonnull RefChangeType refChangeType) {
        Objects.requireNonNull(line, "line");
        Objects.requireNonNull(refChangeType, "refChangeType");
        return MirrorRefHelper.toRefChange(line, refChangeType, -1);
    }

    @Nonnull
    public static MirrorFarmRefChange toRefChange(@Nonnull String line, @Nonnull RefChangeType refChangeType, int changeLocation) {
        Objects.requireNonNull(line, "line");
        Objects.requireNonNull(refChangeType, "refChangeType");
        switch (refChangeType) {
            case ADD: {
                return ((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)new MirrorFarmRefChange.Builder().to(MirrorRefHelper.toRef(line))).fromHash(GitUtils.NULL_SHA1)).type(refChangeType)).changeLocation(changeLocation).build();
            }
            case DELETE: {
                return ((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)new MirrorFarmRefChange.Builder().toHash(GitUtils.NULL_SHA1)).from(MirrorRefHelper.toRef(line))).type(refChangeType)).changeLocation(changeLocation).build();
            }
        }
        throw new IllegalArgumentException("Unsupported change type " + String.valueOf(refChangeType));
    }
}

