/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MirrorClusterNodeAttributesUpdater;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Duration;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAttributeUpdateScheduler
implements LifecycleAware {
    private static final JobId JOB_ID = JobId.of((String)NodeAttributeUpdateScheduler.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)NodeAttributeUpdateScheduler.class.getName());
    private static final Logger log = LoggerFactory.getLogger(NodeAttributeUpdateScheduler.class);
    private final Duration attributeUpdateInterval;
    private final MirrorClusterNodeAttributesUpdater mirrorClusterNodeAttributesUpdater;
    private final SchedulerService schedulerService;

    public NodeAttributeUpdateScheduler(SchedulerService schedulerService, MirroringConfig mirroringConfig, MirrorClusterNodeAttributesUpdater mirrorClusterNodeAttributesUpdater) {
        this.schedulerService = schedulerService;
        this.mirrorClusterNodeAttributesUpdater = mirrorClusterNodeAttributesUpdater;
        this.attributeUpdateInterval = mirroringConfig.getAttributeUpdateInterval();
    }

    public void onStart() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, request -> {
            try {
                this.mirrorClusterNodeAttributesUpdater.maybeUpdateAttributes();
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success();
                return jobRunnerResponse;
            }
            catch (RuntimeException e) {
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((Throwable)e);
                return jobRunnerResponse;
            }
            finally {
                this.scheduleJob(this.attributeUpdateInterval);
            }
        });
        this.scheduleJob(this.attributeUpdateInterval);
    }

    public void onStop() {
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private void scheduleJob(Duration interval) {
        try {
            this.schedulerService.scheduleJobWithGeneratedId(JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce((Date)new Date(System.currentTimeMillis() + interval.toMillis()))));
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule synchronization", (Throwable)e);
        }
    }
}

