/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.mirror.DefaultSyncProgress;
import com.atlassian.bitbucket.mirroring.mirror.SyncProgress;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public class PackedSyncProgress {
    private static final int SIGN_BIT = -128;
    private long value;

    public PackedSyncProgress(SyncProgress progress) {
        Preconditions.checkArgument((progress.getTotalRepos() >= 0 ? 1 : 0) != 0, (Object)"totalRepos must be a positive integer");
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream(8);
             DataOutputStream data = new DataOutputStream(bytes);){
            data.writeInt(progress.getTotalRepos());
            data.writeInt(progress.getSyncedRepos());
            byte[] byteArray = bytes.toByteArray();
            if (progress.getDiscovering()) {
                byteArray[0] = (byte)(byteArray[0] | 0xFFFFFF80);
            }
            this.value = Longs.fromByteArray((byte[])byteArray);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SyncProgress fromValue(long value) {
        DefaultSyncProgress defaultSyncProgress;
        byte[] byteArray = Longs.toByteArray((long)value);
        boolean discovering = false;
        if ((byteArray[0] & 0xFFFFFF80) != 0) {
            discovering = true;
            byteArray[0] = (byte)(byteArray[0] & 0x7F);
        }
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(byteArray));
        try {
            int total = data.readInt();
            int synced = data.readInt();
            defaultSyncProgress = new DefaultSyncProgress(discovering, synced, total);
        }
        catch (Throwable throwable) {
            try {
                try {
                    data.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        data.close();
        return defaultSyncProgress;
    }

    public long toLong() {
        return this.value;
    }
}

