/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MetadataSynchronizer;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncContext;
import com.atlassian.bitbucket.mirroring.mirror.SyncLevel;
import com.atlassian.bitbucket.project.Project;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProjectMetadataSynchronizationOperation
implements MirrorOperation<ExternalProject, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(ProjectMetadataSynchronizationOperation.class);
    private final MetadataSynchronizer metadataSynchronizer;
    private final InternalUpstreamService upstreamService;

    ProjectMetadataSynchronizationOperation(MetadataSynchronizer metadataSynchronizer, InternalUpstreamService upstreamService) {
        this.metadataSynchronizer = metadataSynchronizer;
        this.upstreamService = upstreamService;
    }

    @Override
    @Nonnull
    public Boolean perform(@Nonnull ExternalProject externalProject) {
        Objects.requireNonNull(externalProject, "externalProject");
        InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
        Project updatedProject = this.metadataSynchronizer.synchronizeProject(externalProject, new SyncContext(upstream, ignored -> SyncLevel.DEFAULT));
        if (updatedProject == null) {
            log.warn("{}: External project for upstream {} not updated as local mapping may not exist", MirrorDescriptionUtils.describe(externalProject), MirrorDescriptionUtils.describe(upstream));
            return false;
        }
        log.debug("{}: External project for upstream {} updated successfully", MirrorDescriptionUtils.describe(externalProject), MirrorDescriptionUtils.describe(upstream));
        return true;
    }
}

