/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MinimalExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MetadataSynchronizer;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.RepositoriesSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncContext;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SynchronizationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SynchronizationHelperFactory;
import com.atlassian.bitbucket.mirroring.mirror.SyncLevel;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoriesPostSetupSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(RepositoriesPostSetupSynchronizer.class);
    private final MirrorRepositoryService mirrorRepositoryService;
    private final MetadataSynchronizer metadataSynchronizer;
    private final SynchronizationHelperFactory synchronizationHelperFactory;

    @Autowired
    public RepositoriesPostSetupSynchronizer(MirrorRepositoryService mirrorRepositoryService, MetadataSynchronizer metadataSynchronizer, SynchronizationHelperFactory synchronizationHelperFactory) {
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.metadataSynchronizer = metadataSynchronizer;
        this.synchronizationHelperFactory = synchronizationHelperFactory;
    }

    @Nonnull
    public Set<String> synchronize(@Nonnull RepositoriesSynchronizationRequest request, @Nonnull SyncResult syncResult, @Nonnull UpstreamServer upstream) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(syncResult, "syncResult");
        Objects.requireNonNull(upstream, "upstream");
        if (syncResult.isComplete()) {
            return Sets.newHashSet();
        }
        SynchronizationHelper synchronizationHelper = this.synchronizationHelperFactory.create(request);
        Set<String> unseenExternalRepoIds = syncResult.getUnseenExternalRepositoryIds();
        Set<String> unsyncedExternalRepoIds = syncResult.getUnsyncedExternalRepositoryIds();
        LinkedHashSet<String> newRepoIdsSynced = new LinkedHashSet<String>();
        SyncLevel syncLevel = request.getSyncLevel();
        for (Set externalRepoIds : Arrays.asList(unseenExternalRepoIds, unsyncedExternalRepoIds)) {
            if (externalRepoIds.isEmpty()) continue;
            this.syncRepositories(upstream, externalRepoIds, newRepoIdsSynced, syncLevel);
            synchronizationHelper.deleteProjectsWithoutRepositories(upstream);
        }
        return newRepoIdsSynced;
    }

    private void logForSkippingSynchronization(String externalRepoId, ExternalRepository externalRepository) {
        if (externalRepository == null) {
            log.trace("Skipping synchronization because repository with ID ({}) doesn't exist", (Object)externalRepoId);
        } else {
            log.trace("{}: skipping synchronization because this repository is not mirrored", MirrorDescriptionUtils.describe(externalRepository));
        }
    }

    private void syncRepositories(UpstreamServer upstream, Set<String> externalRepoIds, Set<String> newRepoIdsSynced, SyncLevel syncLevel) {
        String repoIdsList = String.join((CharSequence)", ", externalRepoIds);
        Object upstreamDescription = MirrorDescriptionUtils.describe(upstream);
        int repoIdsSize = externalRepoIds.size();
        log.debug("{}: Performing {} individual synchronizations for these repositories: {}", new Object[]{upstreamDescription, repoIdsSize, repoIdsList});
        this.mirrorRepositoryService.streamExternalRepositories(externalRepoIds, externalRepository -> {
            String externalRepositoryId = externalRepository.getId();
            if (!this.mirrorRepositoryService.isMirrored((MinimalExternalRepository)externalRepository)) {
                this.logForSkippingSynchronization(externalRepositoryId, (ExternalRepository)externalRepository);
                this.mirrorRepositoryService.deleteRepository(externalRepositoryId);
            } else {
                SyncContext syncContext = new SyncContext(upstream, repo -> syncLevel);
                if (this.metadataSynchronizer.synchronizeRepository((ExternalRepository)externalRepository, syncContext) != null) {
                    newRepoIdsSynced.add(externalRepositoryId);
                }
            }
        }, this.mirrorRepositoryService::deleteRepository);
        log.debug("{}: Finished {} individual synchronizations for these repositories: {}", new Object[]{upstreamDescription, repoIdsSize, externalRepoIds});
    }
}

