/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.DefaultBranchUpdateRequest;
import com.atlassian.bitbucket.repository.NoSuchBranchException;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RepositoryDefaultBranchUpdateOperation
implements MirrorOperation<DefaultBranchUpdateRequest, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(RepositoryDefaultBranchUpdateOperation.class);
    private final MirrorRepositoryService mirrorRepositoryService;

    public RepositoryDefaultBranchUpdateOperation(MirrorRepositoryService mirrorRepositoryService) {
        this.mirrorRepositoryService = mirrorRepositoryService;
    }

    @Override
    @Nonnull
    public Boolean perform(@Nonnull DefaultBranchUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        String externalRepositoryId = request.getExternalRepositoryId();
        String newDefaultBranchId = request.getNewDefaultBranchId();
        log.debug("Going to update default branch of repository with ID ({}) to {}", (Object)externalRepositoryId, (Object)newDefaultBranchId);
        try {
            this.mirrorRepositoryService.updateDefaultBranch(externalRepositoryId, newDefaultBranchId);
            log.debug("Updated default branch of repository with ID ({}) to {}", (Object)externalRepositoryId, (Object)newDefaultBranchId);
            return true;
        }
        catch (NoSuchBranchException | NoSuchRepositoryException e) {
            log.error("Could not update default branch of repository with ID ({}) to {}", new Object[]{externalRepositoryId, newDefaultBranchId, e});
            return false;
        }
    }
}

