/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RepositoryDeleteOperation
implements MirrorOperation<String, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(RepositoryDeleteOperation.class);
    private final MirrorRepositoryService mirrorRepositoryService;

    public RepositoryDeleteOperation(MirrorRepositoryService mirrorRepositoryService) {
        this.mirrorRepositoryService = mirrorRepositoryService;
    }

    @Override
    @Nonnull
    public Boolean perform(@Nonnull String externalRepositoryId) {
        Objects.requireNonNull(externalRepositoryId);
        log.debug("Deleting repository with ID ({})", (Object)externalRepositoryId);
        try {
            this.mirrorRepositoryService.deleteRepository(externalRepositoryId);
            log.debug("Repository with ID ({}) deleted successfully", (Object)externalRepositoryId);
            return true;
        }
        catch (Exception e) {
            log.error("Repository with ID ({}) couldn't be deleted", (Object)externalRepositoryId, (Object)e);
            return false;
        }
    }
}

