/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.mirror.MinimalExternalRepository;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;

public class RepositoryMetadataSynchronizationRequest
implements Serializable {
    private static final long serialVersionUID = 4826337340523378095L;
    private final MinimalExternalRepository minimalExternalRepository;
    private final RequestType requestType;

    private RepositoryMetadataSynchronizationRequest(MinimalExternalRepository minimalExternalRepository, RequestType requestType) {
        this.minimalExternalRepository = minimalExternalRepository;
        this.requestType = requestType;
    }

    public static RepositoryMetadataSynchronizationRequest forCreating(@Nonnull MinimalExternalRepository repository) {
        Objects.requireNonNull(repository, "repository");
        return new RepositoryMetadataSynchronizationRequest(repository, RequestType.CREATE);
    }

    public static RepositoryMetadataSynchronizationRequest forDeleting(@Nonnull MinimalExternalRepository repository) {
        Objects.requireNonNull(repository, "repository");
        return new RepositoryMetadataSynchronizationRequest(repository, RequestType.DELETE);
    }

    public static RepositoryMetadataSynchronizationRequest forModifying(@Nonnull MinimalExternalRepository repository) {
        Objects.requireNonNull(repository, "repository");
        return new RepositoryMetadataSynchronizationRequest(repository, RequestType.MODIFY);
    }

    @Nonnull
    public MinimalExternalRepository getMinimalExternalRepository() {
        return this.minimalExternalRepository;
    }

    @Nonnull
    public RequestType getRequestType() {
        return this.requestType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryMetadataSynchronizationRequest that = (RepositoryMetadataSynchronizationRequest)o;
        return Objects.equals(this.minimalExternalRepository, that.minimalExternalRepository) && this.requestType == that.requestType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minimalExternalRepository, this.requestType});
    }

    public String toString() {
        return "RepositoryMetadataSynchronizationRequest{minimalExternalRepository=" + String.valueOf(this.minimalExternalRepository) + ", requestType=" + String.valueOf((Object)this.requestType) + "}";
    }

    public static enum RequestType {
        CREATE,
        DELETE,
        MODIFY;

    }
}

