/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MetadataSynchronizer;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.RepositoryMetadataSynchronizedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncContext;
import com.atlassian.bitbucket.mirroring.mirror.SyncLevel;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SingleRepositoryMetadataSynchronizationOperation
implements MirrorOperation<ExternalRepository, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(SingleRepositoryMetadataSynchronizationOperation.class);
    private final EventPublisher eventPublisher;
    private final MetadataSynchronizer metadataSynchronizer;
    private final InternalUpstreamService upstreamService;

    public SingleRepositoryMetadataSynchronizationOperation(EventPublisher eventPublisher, MetadataSynchronizer metadataSynchronizer, InternalUpstreamService upstreamService) {
        this.eventPublisher = eventPublisher;
        this.metadataSynchronizer = metadataSynchronizer;
        this.upstreamService = upstreamService;
    }

    @Override
    @Nonnull
    public Boolean perform(@Nonnull ExternalRepository externalRepository) {
        boolean success;
        Objects.requireNonNull(externalRepository);
        log.debug("{}: Starting synchronization of external repository", MirrorDescriptionUtils.describe(externalRepository));
        InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
        SyncContext syncContext = new SyncContext(upstream, repositoryId -> SyncLevel.DEFAULT);
        boolean bl = success = this.metadataSynchronizer.synchronizeRepository(externalRepository, syncContext) != null;
        if (success) {
            this.eventPublisher.publish((Object)new RepositoryMetadataSynchronizedEvent(this, syncContext.getSyncedExternalRepositoryIds()));
        }
        return success;
    }
}

