/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.DefaultSyncProgress;
import com.atlassian.bitbucket.internal.mirroring.mirror.SimpleUpstreamSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.SyncProgressUpdatedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoUpstreamSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.UpstreamServerDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.UpstreamSettingRequestWrapper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.mirroring.mirror.NoSuchUpstreamException;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsSetRequest;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsUpdateRequest;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpstreamSettingsOperation
implements MirrorOperation<UpstreamSettingRequestWrapper, UpstreamSettings> {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final TransactionTemplate transactionTemplate;
    private final UpstreamServerDao upstreamServerDao;

    @Autowired
    public UpstreamSettingsOperation(EventPublisher eventPublisher, I18nService i18nService, TransactionTemplate transactionTemplate, UpstreamServerDao upstreamServerDao) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.transactionTemplate = transactionTemplate;
        this.upstreamServerDao = upstreamServerDao;
    }

    @Override
    @Nonnull
    public UpstreamSettings perform(@Nonnull UpstreamSettingRequestWrapper request) {
        UpstreamSettings upstreamSettings = this.updateSettings(request);
        return upstreamSettings == null ? SimpleUpstreamSettings.blank() : upstreamSettings;
    }

    private AoUpstreamSettings toAoUpstreamSettings(UpstreamSettingRequestWrapper request) {
        return switch (request.getType()) {
            case UpstreamSettingRequestWrapper.Type.UPDATE -> this.upstreamSettingsUpdate((UpstreamSettingsUpdateRequest)request.getRequest());
            case UpstreamSettingRequestWrapper.Type.SET -> this.upstreamSettingsSet((UpstreamSettingsSetRequest)request.getRequest());
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)request.getType()));
        };
    }

    private UpstreamSettings updateSettings(UpstreamSettingRequestWrapper request) {
        String upstreamId = request.getRequest().getUpstreamId();
        return (UpstreamSettings)this.transactionTemplate.execute(() -> {
            AoUpstreamServer upstreamServer = this.upstreamServerDao.getById(upstreamId);
            if (upstreamServer == null) {
                throw new NoSuchUpstreamException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.upstream.server", new Object[]{upstreamId}));
            }
            UpstreamSettings oldSettings = UpstreamSettingsUtils.toMirrorSettings(this.upstreamServerDao.getSettingsById(upstreamId), upstreamServer.getLastSettingsChangeDate());
            if (request.getType() == UpstreamSettingRequestWrapper.Type.GET) {
                return oldSettings;
            }
            Date lastSettingsChangeDate = new Date();
            UpstreamSettings newSettings = UpstreamSettingsUtils.toMirrorSettings(this.toAoUpstreamSettings(request), lastSettingsChangeDate);
            if (!newSettings.equals(oldSettings)) {
                upstreamServer.setLastSettingsChangeDate(lastSettingsChangeDate);
                upstreamServer.save();
                this.eventPublisher.publish((Object)new SyncProgressUpdatedEvent(this, new DefaultSyncProgress(this.upstreamServerDao.isDiscovering(upstreamId), 0, 0)));
            }
            return newSettings;
        });
    }

    private AoUpstreamSettings upstreamSettingsSet(@Nonnull UpstreamSettingsSetRequest request) {
        Objects.requireNonNull(request, "request");
        return this.upstreamServerDao.updateSettings(request.getUpstreamId(), request.getMode(), request.getProjectIds());
    }

    private AoUpstreamSettings upstreamSettingsUpdate(@Nonnull UpstreamSettingsUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        return this.upstreamServerDao.updateSettings(request.getUpstreamId(), request.getMode(), request.getAddedProjects(), request.getRemovedProjects());
    }
}

