/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.exception;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.exception.MirrorOperationException;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.google.common.base.Joiner;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MirrorOperationErrorException
extends MirrorOperationException {
    private final Map<Class<? extends Throwable>, List<NodeVmId>> errors;

    public <R extends Serializable> MirrorOperationErrorException(@Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
        super(results, "errors: " + Joiner.on((String)",").withKeyValueSeparator("=").join(errors));
        this.errors = Objects.requireNonNull(errors, "errors");
    }

    @Nonnull
    public Map<Class<? extends Throwable>, List<NodeVmId>> getErrors() {
        return this.errors;
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        ArrayList errorStrings = new ArrayList(this.errors.size());
        this.errors.forEach((aClass, nodeVmIds) -> errorStrings.add(String.valueOf(nodeVmIds) + " => " + aClass.getName()));
        return name + ": " + String.join((CharSequence)", ", errorStrings);
    }
}

