/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.metrics;

import com.atlassian.bitbucket.internal.mirroring.mirror.LogUtils;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JmxHelper {
    public static final String METRIC_CATEGORY_FARM = "farm";
    public static final String METRIC_CATEGORY_OPERATION = "operation";
    public static final String METRIC_CATEGORY_REQUEST = "request";
    public static final String METRIC_KIND_CONTENT = "content";
    public static final String METRIC_KIND_METADATA = "metadata";
    public static final String METRIC_NAME_ALL_PROJECTS = "all-projects";
    public static final String METRIC_NAME_CYCLE_TIME = "cycle-time";
    public static final String METRIC_NAME_VET = "vet";
    public static final String METRIC_TYPE_DISTRIBUTE_FETCH = "distribute-fetch";
    public static final String METRIC_TYPE_REPOSITORY = "repository";
    public static final String METRIC_TYPE_SINGLE_PROJECT = "single-project";
    public static final String METRIC_TYPE_SYNCHRONIZE = "synchronize";
    private static final String MBEAN_NAME_FORMAT = "com.atlassian.bitbucket:type=metrics,category00=%s,category01=%s,category02=%s,name=%s";
    private static final String METRIC_GROUP_MIRROR = "mirror";
    private static final String METRIC_NAME_COUNTER = "counter";
    private static final String TIMER_FORMAT = "%s.%s.%s.%s";
    private static final String TIMER_LONG_FORMAT = "%s.%s.%s.%s.%s";
    private static final String TIMER_SHORT_GROUP_FORMAT = "%s.%s.%s.timer";
    private static final Logger log = LoggerFactory.getLogger(JmxHelper.class);
    private final boolean jmxEnabled;
    private final Set<ObjectName> registeredMBeans = new CopyOnWriteArraySet<ObjectName>();

    @Autowired
    public JmxHelper(ApplicationPropertiesService propertiesService) {
        this.jmxEnabled = propertiesService.isJmxEnabled();
    }

    @Nonnull
    public static String metricName(@Nonnull String category, @Nonnull String type, @Nonnull String name) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(name, "name");
        return String.format(MBEAN_NAME_FORMAT, METRIC_GROUP_MIRROR, category, type, name);
    }

    @Nonnull
    public static String timerName(@Nonnull String category, @Nonnull String type, @Nonnull String name) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(name, "name");
        return String.format(TIMER_FORMAT, METRIC_GROUP_MIRROR, category, type, name);
    }

    @Nonnull
    public static String timerName(@Nonnull String category, @Nonnull String type, @Nonnull String kind, @Nonnull String name) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(kind, "kind");
        return String.format(TIMER_LONG_FORMAT, METRIC_GROUP_MIRROR, category, type, kind, name);
    }

    @Nonnull
    public static String timerNameGrouped(@Nonnull String category, @Nonnull String name) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(name, "name");
        return String.format(TIMER_SHORT_GROUP_FORMAT, METRIC_GROUP_MIRROR, category, name);
    }

    public void maybeRegisterCounterMBean(@Nonnull String category, @Nonnull String name, @Nonnull Object mBean) {
        this.maybeRegisterMBean(JmxHelper.counterMBeanName(category, name), mBean);
    }

    public void maybeRegisterMBean(@Nonnull String objectName, @Nonnull Object mBean) {
        Objects.requireNonNull(mBean, "mBean");
        Objects.requireNonNull(objectName, "objectName");
        if (this.jmxEnabled) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName mBeanName = new ObjectName(objectName);
                if (mBeanServer.isRegistered(mBeanName)) {
                    log.debug("Attempting to register an MBean: {} that has already been registered. Unregistering it", (Object)mBeanName);
                    mBeanServer.unregisterMBean(mBeanName);
                }
                ObjectInstance objectInstance = mBeanServer.registerMBean(mBean, mBeanName);
                this.registeredMBeans.add(objectInstance.getObjectName());
                log.trace("Registered MBean with name {}", (Object)mBeanName);
            }
            catch (InstanceAlreadyExistsException e) {
                log.debug("Attempting to register an MBean: {} that has already been registered", (Object)objectName, (Object)LogUtils.logStacktraceIfEnabled(log.isDebugEnabled(), e));
            }
            catch (RuntimeException | JMException e) {
                log.warn("Could not register MBean with name :{}", (Object)objectName, (Object)LogUtils.logStacktraceIfEnabled(log.isDebugEnabled(), e));
            }
        }
    }

    @PreDestroy
    public void unregisterMBeans() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName registeredMBean : this.registeredMBeans) {
            try {
                this.registeredMBeans.remove(registeredMBean);
                mBeanServer.unregisterMBean(registeredMBean);
            }
            catch (Exception e) {
                log.error("Error unregistering MBean: {} will continue unregistering registered beans", (Object)registeredMBean, (Object)e);
            }
        }
    }

    @VisibleForTesting
    static String counterMBeanName(@Nonnull String category, @Nonnull String name) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(name, "name");
        return String.format(MBEAN_NAME_FORMAT, METRIC_GROUP_MIRROR, category, name, METRIC_NAME_COUNTER);
    }
}

