/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.dmz.mirror.FarmQueueRequest;
import com.atlassian.bitbucket.dmz.mirror.event.MirrorSynchronizedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmQueueProcessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class FarmQueuePoller<T extends Serializable>
implements InitializingBean,
DisposableBean {
    @VisibleForTesting
    static final int MAX_QUEUE_POLLING_ATTEMPTS = 5;
    private static final Logger log = LoggerFactory.getLogger(FarmQueuePoller.class);
    private final ClusterInformation clusterInformation;
    private final ExecutorService executor;
    private final FarmQueue<T> farmQueue;
    private final int initialExceptionBackOffDelayMs;
    private final PluginEventManager pluginEventManager;
    private final FarmQueueProcessor<T> requestProcessor;
    private final int threadCount;
    private volatile boolean running;

    public FarmQueuePoller(ExecutorService executor, FarmQueue<T> farmQueue, int initialExceptionBackOffDelayMs, ClusterService clusterService, PluginEventManager pluginEventManager, FarmQueueProcessor<T> requestProcessor, int threadCount) {
        this.executor = executor;
        this.farmQueue = farmQueue;
        this.initialExceptionBackOffDelayMs = initialExceptionBackOffDelayMs;
        this.pluginEventManager = pluginEventManager;
        this.requestProcessor = requestProcessor;
        this.threadCount = threadCount;
        this.clusterInformation = clusterService.getInformation();
    }

    public void afterPropertiesSet() {
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
        this.running = false;
        this.destroyPoller();
    }

    @EventListener
    public void onMirrorSynchronized(MirrorSynchronizedEvent ignored) {
        if (!this.running) {
            this.running = true;
            for (int i = 0; i < this.threadCount; ++i) {
                this.executor.submit(new QueuePollerTask());
            }
        }
    }

    private void destroyPoller() {
        this.executor.shutdownNow();
    }

    private class QueuePollerTask
    implements Runnable {
        private QueuePollerTask() {
        }

        @Override
        public void run() {
            Duration exceptionBackOff = Duration.ofMillis(FarmQueuePoller.this.initialExceptionBackOffDelayMs);
            int exceptionCount = 0;
            while (FarmQueuePoller.this.running) {
                try {
                    FarmQueueRequest request = FarmQueuePoller.this.farmQueue.take();
                    log.trace("Received {}", (Object)request);
                    FarmQueuePoller.this.requestProcessor.process(request);
                    exceptionCount = 0;
                    exceptionBackOff = Duration.ofMillis(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    if (!FarmQueuePoller.this.clusterInformation.isRunning()) {
                        log.debug("Nutcluster is shutting down. Exiting polling loop.");
                        break;
                    }
                    log.debug("Exception while waiting on nutcluster queue, waiting {} ms", (Object)exceptionBackOff.toMillis());
                    if (++exceptionCount >= 5) {
                        log.error("Exception count of 5 exceeded while waiting on nutcluster queue, breaking out", (Throwable)e);
                        break;
                    }
                    try {
                        Thread.sleep(exceptionBackOff.toMillis());
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    exceptionBackOff = exceptionBackOff.multipliedBy(2L);
                }
            }
        }
    }
}

