/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue;

import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.dmz.mirror.FarmQueueRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmQueueProcessor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RepositoryLockListener;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RequestState;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RequestStatus;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarmRequestLockRetryingProcessor<T extends Serializable>
implements FarmQueueProcessor<T> {
    private static final Logger log = LoggerFactory.getLogger(FarmRequestLockRetryingProcessor.class);
    private final FarmQueueProcessor<T> delegate;
    private final FarmQueue<T> farmQueue;
    private final Function<T, String> repositoryIdSupplier;
    private final RepositoryLockListener repositoryLockListener;

    public FarmRequestLockRetryingProcessor(@Nonnull FarmQueueProcessor<T> delegate, @Nonnull FarmQueue<T> farmQueue, @Nonnull Function<T, String> repositoryIdSupplier, @Nonnull RepositoryLockListener repositoryLockListener) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.farmQueue = Objects.requireNonNull(farmQueue, "farmQueue");
        this.repositoryIdSupplier = Objects.requireNonNull(repositoryIdSupplier, "repositoryIdSupplier");
        this.repositoryLockListener = Objects.requireNonNull(repositoryLockListener, "repositoryLockListener");
    }

    @Override
    @Nonnull
    public RequestStatus process(@Nonnull FarmQueueRequest<T> request) {
        Objects.requireNonNull(request, "request");
        RequestStatus status = this.delegate.process(request);
        if (status.getState() == RequestState.LOCK_FAILURE) {
            this.onLockFailed(request);
        }
        return status;
    }

    protected void onLockFailed(@Nonnull FarmQueueRequest<T> request) {
        String repositoryId = this.repositoryIdSupplier.apply(request.get());
        log.debug("Going to wait for lock to be released for repository with ID ({})", (Object)repositoryId);
        this.repositoryLockListener.waitForLockRelease(repositoryId).whenCompleteAsync((repoId, t) -> {
            if (t != null) {
                log.error("Error while waiting for lock to be released for repository with ID ({})", repoId, t);
            }
            this.onLockReleased(request);
        });
    }

    protected void onLockReleased(@Nonnull FarmQueueRequest<T> originalRequest) {
        log.debug("Submitting request '{}' to queue", originalRequest);
        this.farmQueue.offer(originalRequest);
    }
}

