/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue;

import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.dmz.mirror.FarmQueueRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.BackoffUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.LogUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmQueueProcessor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RequestState;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RequestStatus;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.DedupingScheduledExecutor;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarmRequestRetryingProcessor<T extends Serializable>
implements FarmQueueProcessor<T> {
    private static final Logger log = LoggerFactory.getLogger(FarmRequestRetryingProcessor.class);
    private final FarmQueueProcessor<T> delegate;
    private final DedupingScheduledExecutor executor;
    private final FarmQueue<T> farmQueue;
    private final Duration initialRetryDelay;
    private final int maxAttempts;

    public FarmRequestRetryingProcessor(@Nonnull FarmQueueProcessor<T> delegate, @Nonnull DedupingScheduledExecutor executor, @Nonnull FarmQueue<T> farmQueue, int maxAttempts, @Nonnull Duration initialRetryDelay) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.farmQueue = Objects.requireNonNull(farmQueue, "farmQueue");
        this.maxAttempts = maxAttempts;
        this.initialRetryDelay = Objects.requireNonNull(initialRetryDelay, "initialRetryDelay");
    }

    @Override
    @Nonnull
    public RequestStatus process(@Nonnull FarmQueueRequest<T> request) {
        Objects.requireNonNull(request, "request");
        try {
            RequestStatus requestStatus = this.delegate.process(request);
            if (requestStatus.getState() == RequestState.FAILED) {
                log.debug("Exception while processing request {}", request);
                this.maybeResubmitToQueue(request, requestStatus.getMessage().orElse(""), requestStatus.getThrowable().orElse(null));
            }
            return requestStatus;
        }
        catch (Exception ex) {
            log.debug("Exception while processing request {}", request, (Object)LogUtils.logStacktraceIfEnabled(log.isDebugEnabled(), ex));
            this.maybeResubmitToQueue(request, ex.getMessage(), ex);
            return RequestStatus.failed(ex);
        }
    }

    private void maybeResubmitToQueue(FarmQueueRequest<T> request, String message, Throwable throwable) {
        request.incrementAttempts();
        int attempt = request.getAttempt();
        if (attempt <= this.maxAttempts) {
            long submitDelay = BackoffUtils.exponentialDelay(this.initialRetryDelay.toMillis(), attempt);
            log.warn("Request {} failed attempt {}/{} with message: [{}] waiting {} ms before retrying", new Object[]{request, attempt, this.maxAttempts, message, submitDelay, LogUtils.logStacktraceIfEnabled(log.isDebugEnabled(), throwable)});
            this.executor.schedule(request, () -> this.farmQueue.offer(request), submitDelay, TimeUnit.MILLISECONDS);
        } else {
            log.error("Request {} exhausted retries ({}) message: [{}]", new Object[]{request, this.maxAttempts, message, throwable});
        }
    }
}

