/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue;

import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.dmz.mirror.FarmQueueRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmQueueProcessor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.FarmRequestLockRetryingProcessor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RepositoryLockListener;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarmSynchronizationRequestLockRetryingProcessor
extends FarmRequestLockRetryingProcessor<FarmSynchronizationRequest> {
    private static final Logger log = LoggerFactory.getLogger(FarmSynchronizationRequestLockRetryingProcessor.class);
    private final Map<String, FarmQueueRequest<FarmSynchronizationRequest>> waitingRequests = new ConcurrentHashMap<String, FarmQueueRequest<FarmSynchronizationRequest>>();

    public FarmSynchronizationRequestLockRetryingProcessor(@Nonnull FarmQueueProcessor<FarmSynchronizationRequest> delegate, @Nonnull FarmQueue<FarmSynchronizationRequest> farmQueue, @Nonnull Function<FarmSynchronizationRequest, String> repositoryIdSupplier, @Nonnull RepositoryLockListener repositoryLockListener) {
        super(delegate, farmQueue, repositoryIdSupplier, repositoryLockListener);
    }

    @Override
    protected void onLockFailed(@Nonnull FarmQueueRequest<FarmSynchronizationRequest> request) {
        this.waitingRequests.compute(((FarmSynchronizationRequest)request.get()).getExternalRepositoryId(), (repoId, existingRequest) -> {
            if (existingRequest == null) {
                super.onLockFailed(request);
                return request;
            }
            if (((FarmSynchronizationRequest)existingRequest.get()).getType() == RepositorySynchronizationType.SNAPSHOT || ((FarmSynchronizationRequest)request.get()).getType() == RepositorySynchronizationType.INCREMENTAL) {
                log.debug("Discarding request {} as another request {} already waiting for lock", (Object)request, existingRequest);
                return existingRequest;
            }
            log.debug("Discarding request {} as request {} takes priority when lock is released", existingRequest, (Object)request);
            return request;
        });
    }

    @Override
    protected void onLockReleased(@Nonnull FarmQueueRequest<FarmSynchronizationRequest> originalRequest) {
        String externalRepositoryId = ((FarmSynchronizationRequest)originalRequest.get()).getExternalRepositoryId();
        FarmQueueRequest<FarmSynchronizationRequest> request = this.waitingRequests.remove(externalRepositoryId);
        if (request != null) {
            super.onLockReleased(request);
        }
    }
}

