/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue;

import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappedEvent;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.PluginEventManager;
import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class RepositoryLockListener
implements TopicListener<String>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RepositoryLockListener.class);
    private final ConcurrentHashMap<String, CompletableFuture<String>> repositoryToFutureMap;
    private final PluginEventManager pluginEventManager;
    private final Topic<String> repositoryLockReleaseTopic;
    private String subscriptionId;

    public RepositoryLockListener(PluginEventManager pluginEventManager, Topic<String> repositoryLockReleaseTopic) {
        this.pluginEventManager = pluginEventManager;
        this.repositoryLockReleaseTopic = repositoryLockReleaseTopic;
        this.repositoryToFutureMap = new ConcurrentHashMap();
    }

    public void afterPropertiesSet() {
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
        this.repositoryLockReleaseTopic.unsubscribe(this.subscriptionId);
    }

    @EventListener
    public void onMirrorBootstrapped(MirrorBootstrappedEvent ignored) {
        this.subscriptionId = this.repositoryLockReleaseTopic.subscribe((TopicListener)this);
    }

    public void onMessage(@Nonnull MessageEvent<String> message) {
        this.repositoryToFutureMap.computeIfPresent((String)message.getMessage(), (repoId, future) -> {
            log.debug("Lock has been released on repository with ID ({}), notifying the listeners", repoId);
            future.complete(repoId);
            return null;
        });
    }

    CompletableFuture<String> waitForLockRelease(String repositoryId) {
        return this.repositoryToFutureMap.computeIfAbsent(repositoryId, repoId -> new CompletableFuture());
    }
}

