/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RequestState;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class RequestStatus {
    private final RequestState state;
    private String message;
    private Throwable throwable;

    public RequestStatus(@Nonnull RequestState state, @Nonnull Throwable throwable, @Nonnull String message) {
        this.state = Objects.requireNonNull(state, "requestState");
        this.throwable = Objects.requireNonNull(throwable, "throwable");
        this.message = Objects.requireNonNull(message, "message");
    }

    public RequestStatus(@Nonnull RequestState state, @Nonnull Throwable throwable) {
        this.state = Objects.requireNonNull(state, "requestState");
        this.throwable = Objects.requireNonNull(throwable, "throwable");
    }

    public RequestStatus(@Nonnull RequestState state) {
        this.state = Objects.requireNonNull(state, "requestState");
    }

    public static RequestStatus failed(@Nonnull Throwable throwable, @Nonnull String message) {
        return new RequestStatus(RequestState.FAILED, Objects.requireNonNull(throwable, "throwable"), Objects.requireNonNull(message, "message"));
    }

    public static RequestStatus failed(@Nonnull Throwable throwable) {
        return new RequestStatus(RequestState.FAILED, Objects.requireNonNull(throwable, "throwable"));
    }

    public static RequestStatus lockFailure() {
        return new RequestStatus(RequestState.LOCK_FAILURE);
    }

    public static RequestStatus processed() {
        return new RequestStatus(RequestState.PROCESSED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestStatus that = (RequestStatus)o;
        return this.state == that.state && Objects.equals(this.message, that.message) && Objects.equals(this.throwable, that.throwable);
    }

    @Nonnull
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Nonnull
    public RequestState getState() {
        return this.state;
    }

    @Nonnull
    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.message, this.throwable});
    }

    public String toString() {
        return "RequestStatus{state=" + String.valueOf((Object)this.state) + ", message='" + this.message + "', throwable=" + String.valueOf(this.throwable) + "}";
    }
}

