/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MirrorRefHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.MirrorFarmRefChange;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeIterator;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closer;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeRefChangeIterator
extends AbstractIterator<MirrorFarmRefChange>
implements RefChangeIterator {
    private static final Logger log = LoggerFactory.getLogger(CompositeRefChangeIterator.class);
    private final Closer closer;
    private final Iterator<String> currentRefs;
    private final Iterator<String> targetRefs;
    private boolean currentHandled;
    private Ref currentRef;
    private boolean currentStep;
    private boolean targetHandled;
    private Ref targetRef;
    private boolean targetStep;
    private int changeLocation;

    public CompositeRefChangeIterator(@Nonnull Iterator<String> currentRefs, @Nonnull Iterator<String> targetRefs, @Nonnull Closer closer) {
        this.targetRefs = Objects.requireNonNull(currentRefs, "currentRefs");
        this.currentRefs = Objects.requireNonNull(targetRefs, "targetRefs");
        this.closer = Objects.requireNonNull(closer, "closer");
        if (!this.targetRefs.hasNext() || !this.currentRefs.hasNext()) {
            throw new IllegalStateException("This iterator expects current and target refs");
        }
        log.debug("Calculating difference between current and target refs.");
        this.currentStep = true;
        this.targetStep = true;
        this.changeLocation = 0;
    }

    @Override
    public void close() {
        try {
            this.closer.close();
        }
        catch (Exception e) {
            log.debug("Error while closing readers", (Throwable)e);
        }
    }

    public MirrorFarmRefChange computeNext() {
        while (this.currentRefs.hasNext() || this.targetRefs.hasNext()) {
            if (this.currentStep && this.targetRefs.hasNext()) {
                this.currentRef = MirrorRefHelper.toRef(this.targetRefs.next());
                this.currentHandled = false;
                this.currentStep = false;
            }
            if (this.targetStep && this.currentRefs.hasNext()) {
                ++this.changeLocation;
                this.targetRef = MirrorRefHelper.toRef(this.currentRefs.next());
                this.targetHandled = false;
                this.targetStep = false;
            }
            int comparison = this.targetRef.getId().compareTo(this.currentRef.getId());
            log.trace("target: {} current: {} compareTo: {} changeLocation: {}", new Object[]{this.targetRef.getId(), this.currentRef.getId(), comparison, this.changeLocation});
            if (comparison == 0) {
                this.currentStep = true;
                this.targetStep = true;
                if (!this.targetRef.getLatestCommit().equals(this.currentRef.getLatestCommit())) {
                    this.targetHandled = true;
                    this.currentHandled = true;
                    log.trace("UPDATE: {} -> {}", (Object)this.targetRef.getId(), (Object)this.targetRef.getLatestCommit());
                    return ((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)new MirrorFarmRefChange.Builder(this.targetRef).from(this.currentRef)).to(this.targetRef)).changeLocation(this.changeLocation).type(RefChangeType.UPDATE)).build();
                }
            }
            if (comparison < 0) {
                if (this.currentRefs.hasNext()) {
                    this.targetStep = true;
                    this.targetHandled = true;
                    log.trace("ADD: {} -> {}", (Object)this.targetRef.getId(), (Object)this.targetRef.getLatestCommit());
                    return ((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)new MirrorFarmRefChange.Builder(this.targetRef).fromHash(GitUtils.NULL_SHA1)).to(this.targetRef)).type(RefChangeType.ADD)).changeLocation(this.changeLocation).build();
                }
                this.currentStep = this.targetRefs.hasNext();
                this.currentHandled = true;
                this.targetHandled = this.targetStep;
                log.trace("DELETE: {}", (Object)this.currentRef.getId());
                return ((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)new MirrorFarmRefChange.Builder(this.currentRef).from(this.currentRef)).toHash(GitUtils.NULL_SHA1)).type(RefChangeType.DELETE)).build();
            }
            if (comparison <= 0) continue;
            if (this.targetRefs.hasNext()) {
                this.currentStep = true;
                this.currentHandled = true;
                log.trace("DELETE: {}", (Object)this.currentRef.getId());
                return ((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)new MirrorFarmRefChange.Builder(this.currentRef).from(this.currentRef)).toHash(GitUtils.NULL_SHA1)).type(RefChangeType.DELETE)).build();
            }
            this.targetStep = this.currentRefs.hasNext();
            this.targetHandled = true;
            this.currentHandled = this.currentStep;
            log.trace("ADD: {} -> {}", (Object)this.targetRef.getId(), (Object)this.targetRef.getLatestCommit());
            return ((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)new MirrorFarmRefChange.Builder(this.targetRef).to(this.targetRef)).fromHash(GitUtils.NULL_SHA1)).type(RefChangeType.ADD)).changeLocation(this.changeLocation).build();
        }
        if (this.currentHandled && !this.targetHandled) {
            log.trace("ADD: {} -> {}", (Object)this.targetRef.getId(), (Object)this.targetRef.getLatestCommit());
            this.targetHandled = true;
            return ((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)new MirrorFarmRefChange.Builder(this.targetRef).to(this.targetRef)).fromHash(GitUtils.NULL_SHA1)).type(RefChangeType.ADD)).changeLocation(this.changeLocation).build();
        }
        if (!this.currentHandled && this.targetHandled) {
            this.currentHandled = true;
            log.trace("DELETE: {}", (Object)this.currentRef.getId());
            return ((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)((MirrorFarmRefChange.Builder)new MirrorFarmRefChange.Builder(this.currentRef).from(this.currentRef)).toHash(GitUtils.NULL_SHA1)).type(RefChangeType.DELETE)).build();
        }
        this.close();
        return (MirrorFarmRefChange)this.endOfData();
    }
}

