/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange;

import com.atlassian.bitbucket.internal.mirroring.mirror.command.MirroringCommandFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.CompositeRefChangeIterator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.MirrorFarmRefChange;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeIterator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeWireFormat;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefFileOutCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.SimpleRefChangeIterator;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.io.ReaderLineReader;
import com.atlassian.bitbucket.repository.RefCallback;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closer;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RefChangeCalculator {
    private static final Logger log = LoggerFactory.getLogger(RefChangeCalculator.class);
    private final MirroringCommandFactory mirroringCommandFactory;
    private final Path tempDir;

    @Autowired
    public RefChangeCalculator(MirroringCommandFactory mirroringCommandFactory, StorageService storageService) {
        this.mirroringCommandFactory = mirroringCommandFactory;
        this.tempDir = storageService.getTempDir();
    }

    public RefChangeIterator localDiff(@Nonnull Path changes, @Nonnull MirrorRepository mirrorRepository) {
        Objects.requireNonNull(changes, "changes");
        Objects.requireNonNull(mirrorRepository, "mirrorRepository");
        Path forEachRefFile = null;
        try {
            Repository repository = mirrorRepository.getRepository();
            forEachRefFile = Files.createTempFile(this.tempDir, repository.getId() + "-local-diff-for-each-ref", null, new FileAttribute[0]);
            try {
                RefFileOutCallback callback = new RefFileOutCallback(forEachRefFile);
                GitCommand<Void> command = this.mirroringCommandFactory.refs(mirrorRepository, (RefCallback)callback);
                command.call();
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Unexpected error generating a list of changes", e);
            }
            if (log.isTraceEnabled()) {
                this.logCommandOutput(changes, forEachRefFile);
            }
            ReaderLineReader forEachRefLineReader = new ReaderLineReader((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream(forEachRefFile, new OpenOption[0]), StandardCharsets.UTF_8)));
            BufferedReader changesReader = new BufferedReader(new InputStreamReader(Files.newInputStream(changes, new OpenOption[0]), StandardCharsets.UTF_8));
            return this.diff(forEachRefLineReader, new WireToRefLineReader(changesReader), new TempDirCleaner(forEachRefFile));
        }
        catch (IOException | RuntimeException e) {
            try {
                if (forEachRefFile != null) {
                    Files.delete(forEachRefFile);
                }
            }
            catch (IOException ex) {
                log.error("Failed to delete temporary directory used generating ref changes {}", (Object)this.tempDir, (Object)ex);
            }
            if (e instanceof IOException) {
                throw new UncheckedIOException("Failed to write ref changes to directory " + String.valueOf(this.tempDir), (IOException)e);
            }
            throw (RuntimeException)e;
        }
    }

    public RefChangeIterator remoteDiff(@Nonnull MirrorRepository mirrorRepository) {
        Objects.requireNonNull(mirrorRepository, "mirrorRepository");
        Path tmpDir = null;
        try {
            Repository repository = mirrorRepository.getRepository();
            tmpDir = Files.createTempDirectory(this.tempDir, "ref-change-calculations" + repository.getId(), new FileAttribute[0]);
            Path lsRemoteFile = tmpDir.resolve("ls-remote");
            Path forEachRefFile = tmpDir.resolve("for-each-ref");
            Future lsRemote = this.mirroringCommandFactory.lsRemote(mirrorRepository, (RefCallback)new RefFileOutCallback(lsRemoteFile)).asynchronous().start();
            try {
                GitCommand<Void> refsCommand = this.mirroringCommandFactory.refs(mirrorRepository, (RefCallback)new RefFileOutCallback(forEachRefFile));
                refsCommand.call();
                lsRemote.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException | ExecutionException e) {
                throw new RuntimeException("Unexpected error generating a list of changes", e);
            }
            finally {
                lsRemote.cancel(true);
            }
            if (log.isTraceEnabled()) {
                this.logCommandOutput(lsRemoteFile, forEachRefFile);
            }
            ReaderLineReader lsRemoteLineReader = new ReaderLineReader((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream(lsRemoteFile, new OpenOption[0]), StandardCharsets.UTF_8)));
            ReaderLineReader forEachRefLineReader = new ReaderLineReader((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream(forEachRefFile, new OpenOption[0]), StandardCharsets.UTF_8)));
            return this.diff(forEachRefLineReader, lsRemoteLineReader, new TempDirCleaner(tmpDir));
        }
        catch (IOException | RuntimeException e) {
            try {
                if (tmpDir != null) {
                    MoreFiles.deleteRecursively(tmpDir);
                }
            }
            catch (IOException ex) {
                log.error("Failed to delete temporary directory used generating ref changes {}", (Object)this.tempDir, (Object)ex);
            }
            if (e instanceof IOException) {
                throw new UncheckedIOException("Failed to create temporary directory used for generating ref changes in " + String.valueOf(this.tempDir), (IOException)e);
            }
            throw (RuntimeException)e;
        }
    }

    public RefChangeIterator snapshot(@Nonnull MirrorRepository mirrorRepository) {
        Objects.requireNonNull(mirrorRepository, "mirrorRepository");
        Path lsRemoteFile = null;
        try {
            Repository repository = mirrorRepository.getRepository();
            lsRemoteFile = Files.createTempFile(this.tempDir, repository.getId() + "-snapshot-ls-remote", null, new FileAttribute[0]);
            this.mirroringCommandFactory.lsRemote(mirrorRepository, (RefCallback)new RefFileOutCallback(lsRemoteFile)).call();
            ReaderLineReader lsRemoteLineReader = new ReaderLineReader((Reader)Files.newBufferedReader(lsRemoteFile));
            Closer closer = Closer.create();
            Iterator remoteRefs = ((ReaderLineReader)closer.register((Closeable)lsRemoteLineReader)).iterator();
            closer.register((Closeable)new TempDirCleaner(lsRemoteFile));
            return new SimpleRefChangeIterator(remoteRefs, RefChangeType.ADD, closer);
        }
        catch (IOException | RuntimeException e) {
            try {
                if (lsRemoteFile != null) {
                    Files.delete(lsRemoteFile);
                }
            }
            catch (IOException ex) {
                log.error("Failed to delete temporary directory used generating snapshot {}", (Object)this.tempDir, (Object)ex);
            }
            if (e instanceof IOException) {
                throw new UncheckedIOException("Failed to write snapshot to directory " + String.valueOf(this.tempDir), (IOException)e);
            }
            throw (RuntimeException)e;
        }
    }

    private RefChangeIterator diff(ReaderLineReader localRefReader, ReaderLineReader remoteRefReader, TempDirCleaner tempDirCleaner) {
        Closer closer = Closer.create();
        Iterator localRefs = ((ReaderLineReader)closer.register((Closeable)localRefReader)).iterator();
        Iterator remoteRefs = ((ReaderLineReader)closer.register((Closeable)remoteRefReader)).iterator();
        closer.register((Closeable)tempDirCleaner);
        if (localRefs.hasNext()) {
            if (remoteRefs.hasNext()) {
                return new CompositeRefChangeIterator(localRefs, remoteRefs, closer);
            }
            log.debug("No refs found on remote");
            return new SimpleRefChangeIterator(localRefs, RefChangeType.DELETE, closer);
        }
        if (remoteRefs.hasNext()) {
            log.debug("Generating refspec containing all refs advertised by remote.");
            return new SimpleRefChangeIterator(remoteRefs, RefChangeType.ADD, closer);
        }
        try {
            closer.close();
        }
        catch (Exception e) {
            log.warn("Error closing readers", (Throwable)e);
        }
        log.debug("No refs found on remote and local");
        return new EmptyRefChangeIterator();
    }

    private void logCommandOutput(Path lsRemoteFile, Path forEachRefFile) throws IOException {
        try (ReaderLineReader lsRemoteLineReader = new ReaderLineReader((Reader)Files.newBufferedReader(lsRemoteFile));
             ReaderLineReader forEachRefLineReader = new ReaderLineReader((Reader)Files.newBufferedReader(forEachRefFile));){
            log.trace("==== ls-remote output ===");
            lsRemoteLineReader.stream().map(s -> "ls-remote:" + s).forEach(arg_0 -> ((Logger)log).trace(arg_0));
            log.trace("==== for-each-ref output ===");
            forEachRefLineReader.stream().map(s -> "for-each-ref:" + s).forEach(arg_0 -> ((Logger)log).trace(arg_0));
        }
    }

    private static class WireToRefLineReader
    extends ReaderLineReader {
        WireToRefLineReader(Reader in) {
            super(in);
        }

        public String readLine() throws IOException {
            return RefChangeWireFormat.wireToRef(super.readLine());
        }
    }

    private static class TempDirCleaner
    implements Closeable {
        private final Path tmpDir;

        private TempDirCleaner(Path tmpDir) {
            this.tmpDir = tmpDir;
        }

        @Override
        public void close() throws IOException {
            if (this.tmpDir != null) {
                MoreFiles.deleteRecursively((Path)this.tmpDir);
            }
        }
    }

    @VisibleForTesting
    public static class EmptyRefChangeIterator
    implements RefChangeIterator {
        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public MirrorFarmRefChange next() {
            throw new NoSuchElementException("This RefChangeIterator is empty");
        }
    }
}

