/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.ChunkPayload;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;

public class RefChangeChunk
implements Serializable {
    private final byte[] digest;
    private final FarmSynchronizationRequest farmSynchronizationRequest;
    private final int index;
    private final boolean last;
    private final String orchestratingNodeVmId;
    private final byte[] payload;

    public RefChangeChunk(@Nonnull ChunkPayload chunkPayload, @Nonnull FarmSynchronizationRequest farmSynchronizationRequest, @Nonnull String orchestratingNodeVmId, boolean last, int index) {
        Objects.requireNonNull(chunkPayload, "chunkPayload");
        this.farmSynchronizationRequest = Objects.requireNonNull(farmSynchronizationRequest, "farmSynchronizationRequest");
        this.orchestratingNodeVmId = Objects.requireNonNull(orchestratingNodeVmId, "orchestratingNodeVmId");
        this.payload = chunkPayload.getPayload();
        this.digest = chunkPayload.getPayloadDigest();
        this.last = last;
        this.index = index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefChangeChunk that = (RefChangeChunk)o;
        return this.last == that.last && this.index == that.index && Arrays.equals(this.payload, that.payload) && Arrays.equals(this.digest, that.digest) && this.farmSynchronizationRequest.equals(that.farmSynchronizationRequest);
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public String getOrchestratingNodeVmId() {
        return this.orchestratingNodeVmId;
    }

    public String getExternalRepositoryId() {
        return this.farmSynchronizationRequest.getExternalRepositoryId();
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public RepositorySynchronizationType getSynchronizationType() {
        return this.farmSynchronizationRequest.getType();
    }

    public int hashCode() {
        int result = Objects.hash(this.farmSynchronizationRequest, this.index, this.last);
        result = 31 * result + Arrays.hashCode(this.digest);
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }

    public boolean isLast() {
        return this.last;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("farmSynchronizationRequest", (Object)this.farmSynchronizationRequest).add("last", this.last).add("index", this.index).add("digest", (Object)Hex.encodeHexString((byte[])this.digest)).add("payload.length", this.payload.length).toString();
    }
}

