/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeChunk;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangePublisher;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.MoreFiles;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class RefChangeChunkOperation
implements MirrorOperation<RefChangeChunk, String> {
    public static final String CHANGES_DIRECTORY = "ref-changes";
    public static final String CHUNK_DIRECTORY = "ref-change-chunks";
    private static final Logger log = LoggerFactory.getLogger(RefChangeChunkOperation.class);
    private final Path chunkParentDir;
    private final MirrorOperation<RepositorySynchronizationRequest, RepositorySynchronizationResponse> objectFetchOperation;
    private final Path refChangeParentDir;

    @Autowired
    public RefChangeChunkOperation(StorageService storageService, @Qualifier(value="objectFetchOperation") MirrorOperation<RepositorySynchronizationRequest, RepositorySynchronizationResponse> objectFetchOperation) {
        this.objectFetchOperation = objectFetchOperation;
        Path tempDir = storageService.getTempDir();
        this.chunkParentDir = tempDir.resolve(CHUNK_DIRECTORY);
        this.refChangeParentDir = tempDir.resolve(CHANGES_DIRECTORY);
    }

    @Override
    @Nonnull
    public String perform(@Nonnull RefChangeChunk chunk) {
        Objects.requireNonNull(chunk, "request");
        log.trace("Received: {}", (Object)chunk);
        Path chunkDir = this.repositoryDir(chunk, this.chunkParentDir);
        Path refChangeDir = this.repositoryDir(chunk, this.refChangeParentDir);
        this.writeChunk(chunk, chunkDir);
        if (!chunk.isLast()) {
            return Hex.encodeHexString((byte[])chunk.getDigest());
        }
        String changeId = this.assemble(chunkDir, refChangeDir);
        return this.objectFetchOperation.perform(new RepositorySynchronizationRequest(chunk, changeId)).getChangeId();
    }

    private Consumer<Path> appendChunk(OutputStream outputStream) {
        return chunk -> {
            try {
                Files.copy(chunk, outputStream);
                Files.delete(chunk);
            }
            catch (IOException e) {
                log.error("Error accessing: {}", chunk);
                throw new UncheckedIOException(e);
            }
        };
    }

    @Nonnull
    private String assemble(Path chunkDir, Path refChangeDir) {
        try {
            Path changes;
            String contentHash;
            UUID uuid = UUID.randomUUID();
            Path temp = refChangeDir.resolve(uuid.toString());
            MoreFiles.cleanDirectory((Path)refChangeDir);
            Files.createFile(temp, new FileAttribute[0]);
            MessageDigest sha1 = DigestUtils.getSha1Digest();
            try (FileOutputStream fileOutputStream = new FileOutputStream(temp.toFile());
                 DigestOutputStream outputStream = new DigestOutputStream(fileOutputStream, sha1);
                 Stream<Path> chunkStream = Files.list(chunkDir);){
                int[] counter = new int[1];
                byte[] operationDigest = chunkStream.sorted(Comparator.comparingInt(v -> Integer.parseInt(v.getFileName().toString()))).peek(this.appendChunk(outputStream)).peek(path -> {
                    counter[0] = counter[0] + 1;
                }).map(this.digest(sha1)).reduce(new byte[sha1.getDigestLength()], RefChangePublisher::xor);
                contentHash = Hex.encodeHexString((byte[])operationDigest);
                changes = refChangeDir.resolve(contentHash);
                log.debug("Assembled {} chunks into temp file: {} and moving to content addressable file: {}", new Object[]{counter[0], temp, changes});
            }
            Files.move(temp, changes, new CopyOption[0]);
            return contentHash;
        }
        catch (IOException e) {
            log.error("Error assembling chunks from: {} to: {}", (Object)chunkDir, (Object)refChangeDir);
            throw new UncheckedIOException(e);
        }
    }

    private Function<Path, byte[]> digest(MessageDigest sha1Digest) {
        return path -> {
            byte[] digest = sha1Digest.digest();
            sha1Digest.reset();
            return digest;
        };
    }

    private Path repositoryDir(RefChangeChunk chunk, Path parent) {
        String repositoryId = chunk.getExternalRepositoryId();
        Path repositoryPath = parent.resolve(repositoryId);
        if (!Files.exists(repositoryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(repositoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not create directory: " + String.valueOf(repositoryPath) + " for repository: " + repositoryId, e);
            }
        }
        return repositoryPath;
    }

    private void writeChunk(@Nonnull RefChangeChunk chunk, Path repositoryChunkPath) {
        Path chunkPath = repositoryChunkPath.resolve(String.valueOf(chunk.getIndex()));
        try {
            if (Files.exists(chunkPath, new LinkOption[0])) {
                try (FileInputStream is = new FileInputStream(chunkPath.toFile());){
                    if (Arrays.equals(DigestUtils.sha1((InputStream)is), chunk.getDigest())) {
                        return;
                    }
                }
                log.error("Unexpected chunk file: {} deleting directory: {}", (Object)chunkPath, (Object)repositoryChunkPath);
                PathUtils.cleanDirectory((Path)repositoryChunkPath, (DeleteOption[])new DeleteOption[]{StandardDeleteOption.OVERRIDE_READ_ONLY});
                throw new IllegalStateException("Unexpected chunk file " + String.valueOf(chunkPath));
            }
            if (chunk.getIndex() == 0) {
                log.trace("Start of a new operation. Deleting all files in {}", (Object)repositoryChunkPath);
                PathUtils.cleanDirectory((Path)repositoryChunkPath, (DeleteOption[])new DeleteOption[]{StandardDeleteOption.OVERRIDE_READ_ONLY});
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(chunk.getPayload());
            DigestInputStream inputStream = new DigestInputStream(new GZIPInputStream(bis), DigestUtils.getSha1Digest());
            Files.copy(inputStream, chunkPath, new CopyOption[0]);
            byte[] fileDigest = inputStream.getMessageDigest().digest();
            if (!Arrays.equals(fileDigest, chunk.getDigest())) {
                String actual = Hex.encodeHexString((byte[])fileDigest);
                String expected = Hex.encodeHexString((byte[])chunk.getDigest());
                log.error("Message digest: {} does not match expected digest: {} for index: {}", new Object[]{expected, actual, chunk.getIndex()});
                throw new IllegalStateException("Message digest " + actual + " does not match expected " + expected);
            }
        }
        catch (IOException e) {
            log.error("Error writing chunk:{} to path :{}", (Object)chunk, (Object)chunkPath);
            throw new UncheckedIOException(e);
        }
    }
}

