/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.metrics.JmxHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.ChunkPayload;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.MirrorFarmRefChange;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeChunk;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeIterator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeWireFormat;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.collect.UnmodifiableIterator;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RefChangePublisher {
    public static final String EMPTY_CHANGE_ID = Hex.encodeHexString((byte[])new byte[DigestUtils.getSha1Digest().getDigestLength()]);
    private static final Logger log = LoggerFactory.getLogger(RefChangePublisher.class);
    private final int maxChunkSize;
    private final RequestReplyTopic<RefChangeChunk, String> refChangeChunkTopic;

    @Autowired
    public RefChangePublisher(MirroringConfig mirroringConfig, RequestReplyTopic<RefChangeChunk, String> refChangeChunkTopic) {
        this.refChangeChunkTopic = refChangeChunkTopic;
        this.maxChunkSize = mirroringConfig.getMaxChunkSize();
    }

    @Nonnull
    public String publish(@Nonnull RefChangeIterator changes, @Nonnull FarmSynchronizationRequest farmSynchronizationRequest, @Nonnull String orchestratingNodeVmId) {
        Objects.requireNonNull(changes, "changes");
        Objects.requireNonNull(farmSynchronizationRequest, "farmSynchronizationRequest");
        Objects.requireNonNull(orchestratingNodeVmId, "orchestratingNodeVmId");
        String synchronizationType = farmSynchronizationRequest.getType().toString();
        try (Ticker ignored = Timers.timerWithMetric((String)JmxHelper.timerName("farm", "distribute-fetch", synchronizationType)).start(new String[0]);){
            AtomicInteger index = new AtomicInteger(0);
            UnmodifiableIterator chunks = Iterators.partition((Iterator)changes, (int)this.maxChunkSize);
            if (log.isTraceEnabled()) {
                log.trace("Publishing RefChangeChunks for repository with ID ({})", (Object)farmSynchronizationRequest.getExternalRepositoryId());
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(128);
            MessageDigest sha1 = DigestUtils.getSha1Digest();
            String string = Hex.encodeHexString((byte[])Streams.stream((Iterator)chunks).map(chunk -> this.createPayload((List<MirrorFarmRefChange>)chunk, buffer, sha1)).peek(chunkPayload -> this.publishChunk(farmSynchronizationRequest, (ChunkPayload)chunkPayload, orchestratingNodeVmId, index.getAndIncrement(), !chunks.hasNext())).map(ChunkPayload::getPayloadDigest).reduce(new byte[sha1.getDigestLength()], RefChangePublisher::xor));
            return string;
        }
    }

    static byte[] xor(byte[] cd1, byte[] cd2) {
        for (int i = 0; i < cd1.length; ++i) {
            int n = i;
            cd1[n] = (byte)(cd1[n] ^ cd2[i]);
        }
        return cd1;
    }

    private ChunkPayload createPayload(List<MirrorFarmRefChange> changes, ByteArrayOutputStream buffer, MessageDigest sha1) {
        buffer.reset();
        sha1.reset();
        try (DigestOutputStream out = new DigestOutputStream(new GZIPOutputStream(buffer), sha1);){
            changes.stream().map(RefChangeWireFormat::refChangeToWire).map(s -> s.getBytes(StandardCharsets.UTF_8)).forEach(b -> {
                try {
                    out.write((byte[])b);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        byte[] digest = sha1.digest();
        return new ChunkPayload(buffer.toByteArray(), digest);
    }

    private void publishChunk(FarmSynchronizationRequest farmSynchronizationRequest, ChunkPayload payload, String orchestratingNodeVmId, int index, boolean last) {
        RefChangeChunk chunk = new RefChangeChunk(payload, farmSynchronizationRequest, orchestratingNodeVmId, last, index);
        log.trace("Publishing: {}", (Object)chunk);
        this.refChangeChunkTopic.publish(chunk);
    }
}

