/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MirrorRefHelper;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import jakarta.annotation.Nullable;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public final class RefChangeWireFormat {
    private static final char ADD_INSTRUCTION = '+';
    private static final String ADD_FORMAT = "+%s\u0000%s\n";
    private static final char DELETE_INSTRUCTION = '-';
    private static final String DELETE_FORMAT = "-%s\u0000%s\n";
    private static final char UPDATE_INSTRUCTION = '=';
    private static final String UPDATE_FORMAT = "=%s\u0000%s\u0000%s\n";

    private RefChangeWireFormat() {
    }

    public static boolean isFetchInstruction(@Nullable String wire) {
        if (wire == null) {
            return false;
        }
        char type = wire.charAt(0);
        return type == '+' || type == '=';
    }

    public static String refChangeToUpdateInstructions(RefChange refChange) {
        String refId = refChange.getRef().getId();
        switch (refChange.getType()) {
            case ADD: 
            case UPDATE: {
                return String.format("update %s\u0000%s\u0000\u0000", refId, refChange.getToHash());
            }
            case DELETE: {
                return String.format("delete %s\u0000\u0000", refId);
            }
        }
        throw new IllegalArgumentException("Unexpected RefChangeType: " + String.valueOf(refChange.getType()));
    }

    public static String refChangeToWire(RefChange refChange) {
        String refId = refChange.getRef().getId();
        switch (refChange.getType()) {
            case ADD: {
                return String.format(ADD_FORMAT, refChange.getToHash(), refId);
            }
            case UPDATE: {
                return String.format(UPDATE_FORMAT, refChange.getToHash(), refChange.getFromHash(), refId);
            }
            case DELETE: {
                return String.format(DELETE_FORMAT, refChange.getFromHash(), refId);
            }
        }
        throw new IllegalArgumentException("Unexpected RefChangeType: " + String.valueOf(refChange.getType()));
    }

    public static RefChange wireToRefChange(@Nullable String wire) {
        return RefChangeWireFormat.parseWireRef(wire, RefChangeWireFormat::refChangeAdd, RefChangeWireFormat::refChangeUpdate, RefChangeWireFormat::refChangeDelete);
    }

    @Nullable
    public static String wireToRefspec(@Nullable String wire) {
        return RefChangeWireFormat.parseWireRef(wire, add -> add[0], update -> update[0], delete -> null);
    }

    @Nullable
    public static String wireToUpdateInstructions(@Nullable String wire) {
        return RefChangeWireFormat.parseWireRef(wire, add -> String.format("update %s\u0000%s\u0000\u0000", add[1], add[0]), update -> String.format("update %s\u0000%s\u0000\u0000", update[2], update[0]), delete -> String.format("delete %s\u0000\u0000", delete[1]));
    }

    @Nullable
    static String wireToRef(@Nullable String wire) {
        return RefChangeWireFormat.parseWireRef(wire, add -> String.format("%s\t%s", add[0], add[1]), update -> String.format("%s\t%s", update[0], update[2]), delete -> null);
    }

    @Nullable
    private static <T> T parseWireRef(@Nullable String wire, Function<String[], T> add, Function<String[], T> update, Function<String[], T> delete) {
        if (wire == null) {
            return null;
        }
        char type = wire.charAt(0);
        String[] pieces = wire.substring(1).trim().split("\u0000");
        if (type == '+') {
            return add.apply(pieces);
        }
        if (type == '=') {
            return update.apply(pieces);
        }
        if (type == '-') {
            return delete.apply(pieces);
        }
        throw new IllegalArgumentException("Invalid change type " + type);
    }

    private static RefChange refChangeAdd(String[] pieces) {
        Ref toRef = MirrorRefHelper.toRef(pieces[0] + "\t" + pieces[1]);
        return ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().to(toRef)).fromHash(StringUtils.repeat((String)"0", (int)40))).type(RefChangeType.ADD)).build();
    }

    private static RefChange refChangeDelete(String[] pieces) {
        Ref fromRef = MirrorRefHelper.toRef(pieces[0] + "\t" + pieces[1]);
        return ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().toHash(StringUtils.repeat((String)"0", (int)40))).from(fromRef)).type(RefChangeType.DELETE)).build();
    }

    private static RefChange refChangeUpdate(String[] pieces) {
        Ref toRef = MirrorRefHelper.toRef(pieces[0] + "\t" + pieces[2]);
        return ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().to(toRef)).fromHash(pieces[1])).type(RefChangeType.UPDATE)).build();
    }
}

